/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.ext.ParamValueProxyFactory;
import pl.decerto.hyperon.runtime.decoder.MpCascadeDecoder;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.MpDomainAttributeDto;

public class AttributeValueResolver {
    private final HyperonEngine engine;
    private final MpCascadeDecoder decoder;

    public AttributeValueResolver(HyperonEngine engine) {
        this.engine = engine;
        this.decoder = new MpCascadeDecoder(engine);
    }

    public ParamValue getValue(HyperonDomainAttribute attr, ParamContext ctx, Object ... args) {
        Object value;
        MpDomainAttributeDto.RawType type = attr.getRawType();
        String text = attr.getRawValue();
        switch (type) {
            case LITERAL: {
                value = text;
                break;
            }
            case PARAMETER: {
                value = this.processParameter(ctx, text);
                break;
            }
            case FUNCTION: {
                value = this.processFunction(ctx, text, args);
                break;
            }
            default: {
                throw new HyperonRuntimeException("unsupported type: " + (Object)((Object)type));
            }
        }
        return ParamValueProxyFactory.get(value);
    }

    private Object processFunction(ParamContext ctx, String value, Object ... args) {
        if (this.isSimpleFunction(value)) {
            return this.engine.call(value, ctx, args);
        }
        return this.decoder.cascadeCall(value, ctx);
    }

    private Object processParameter(ParamContext ctx, String value) {
        if (this.isSimpleParameter(value)) {
            return this.engine.get(value, ctx);
        }
        return this.decoder.cascadeGet(value, ctx);
    }

    private boolean isSimpleParameter(String value) {
        return !value.contains("[");
    }

    private boolean isSimpleFunction(String value) {
        return !value.contains("(") && !value.contains("[");
    }
}

