/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.RhinoSimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.params.CapitalControl;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class ChargeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargeCollector.class);

    public void calculateSurrender(SimulationLifeContext context, String parameterName, String chargeCode, boolean baseOnCapital) {
        this.calculateSurrenderValueForAccount(context, parameterName, chargeCode, baseOnCapital);
    }

    public void collectChargeFromDebt(SimulationLifeContext context) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            this.collectAccountChargeFromDebt(account, context.getChargePhase(), simulationData.getCapitalControl());
        }
    }

    public void collectChargeForAccountOrFunds(SimulationLifeContext context, String parameterName, boolean onlyForAccount) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            context.setCurrentAccount(account);
            List<ChargeDefinition> rhinoCollectors = ChargeDefinition.findCollectors(parameterName, context);
            for (ChargeDefinition chargeDefinition : rhinoCollectors) {
                context.setCurrentChargeDefinition(chargeDefinition);
                if (onlyForAccount) {
                    this.collectChargesFromRhinoOrApi(context, chargeDefinition);
                    continue;
                }
                this.collectChargesForFunds(context);
            }
        }
    }

    public void collectChargeForFund(SimulationLifeContext context, String account, String fund, BigDecimal amount, ChargeDefinition chargeDefinition) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountData.getCode().equals(account)) continue;
            InvestPolicyValueSimulationContext.Fund fundData = accountData.getFund(fund);
            BigDecimal fundChargeInUnits = SimulationMathematicalFunctions.divide(amount, fundData.getUnitPrice());
            accountData.addChargeToDebt(new InvestPolicyValueSimulationContext.FundCharge(fundData.getFundDefinition(), fundChargeInUnits, chargeDefinition, new ChargeValueDefinition(amount, ChargeValueDefinition.Type.AMOUNT)));
            break;
        }
    }

    public void collectChargeForFund(SimulationLifeContext context, BigDecimal amount) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        if (account != null && fund != null && SimulationMathematicalFunctions.greaterThanZero(fund.getUnitPrice())) {
            BigDecimal fundChargeInUnits = SimulationMathematicalFunctions.divide(amount, fund.getUnitPrice());
            account.addChargeToDebt(new InvestPolicyValueSimulationContext.FundCharge(fund.getFundDefinition(), fundChargeInUnits, context.getCurrentChargeDefinition(), new ChargeValueDefinition(amount, ChargeValueDefinition.Type.AMOUNT)));
        }
    }

    public void collectChargeForAccount(SimulationLifeContext context, String account, String fund, BigDecimal amount, ChargeDefinition chargeDefinition) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountData.getCode().equals(account)) continue;
            BigDecimal totalUnits = accountData.getTotalUnits();
            InvestPolicyValueSimulationContext.Fund fundData = accountData.getFund(fund);
            this.addPropotionalCharge(context, amount, accountData, totalUnits, fundData, chargeDefinition);
            break;
        }
    }

    public void collectChargeForAccount(SimulationLifeContext context, BigDecimal amount) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        if (account != null && fund != null) {
            BigDecimal totalUnits = account.getTotalUnits();
            this.addPropotionalCharge(context, amount, account, totalUnits, fund, context.getCurrentChargeDefinition());
        }
    }

    public void addChargeWithoutDeduction(SimulationLifeContext context, String accountCode, String fundCode, ChargeDefinition chargeDefinition, ChargeValueDefinition valueDefinition, BigDecimal chargedUnits) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountData.getCode().equals(accountCode)) continue;
            CollectedCharge charge = new CollectedCharge(accountCode, chargeDefinition, valueDefinition);
            charge.setPhase(context.getChargePhase());
            if (StringUtils.isEmpty((CharSequence)fundCode)) {
                charge.withChargedAmount(valueDefinition.getValue());
            } else {
                charge.withChargedAmount(fundCode, valueDefinition.getValue());
                charge.withChargedUnits(fundCode, chargedUnits);
            }
            accountData.addCollectedCharge(charge);
        }
    }

    private void collectChargesFromRhinoOrApi(SimulationLifeContext context, ChargeDefinition chargeDefinition) {
        if (context.getSimulationData().isBaseOnParameter() || StringUtils.isEmpty((CharSequence)chargeDefinition.getChargeValueParameter())) {
            this.callRhinoFunction(context, chargeDefinition);
        } else {
            this.callMethod(context, chargeDefinition);
        }
    }

    private void collectAccountChargeFromDebt(InvestPolicyValueSimulationContext.SuspenseAccount account, String phase, CapitalControl capitalControl) {
        List<InvestPolicyValueSimulationContext.FundCharge> charges = account.getDebt();
        Iterator<InvestPolicyValueSimulationContext.FundCharge> chargesIterator = charges.iterator();
        while (chargesIterator.hasNext()) {
            InvestPolicyValueSimulationContext.FundCharge charge = chargesIterator.next();
            InvestPolicyValueSimulationContext.Fund fund = account.getFund(charge.getFundDefinition().getCode());
            BigDecimal fundChargeInUnits = charge.getUnits();
            if (capitalControl != CapitalControl.NO_CONTROL && fundChargeInUnits.compareTo(fund.getUnits()) > 0) {
                switch (capitalControl) {
                    case NO_DEBT: {
                        fundChargeInUnits = fund.getUnits();
                        break;
                    }
                    case EXCEPTION_AT_DEBT: {
                        throw new HyperonRuntimeException("Charge " + charge.getChargeDefinition().getCode() + " in units " + fundChargeInUnits + " greater then units " + fund.getUnits() + " for fund " + fund.getCode());
                    }
                }
            }
            BigDecimal fundChargeAmount = SimulationMathematicalFunctions.multiply(charge.getUnits(), fund.getUnitPrice());
            fund.setUnits(SimulationMathematicalFunctions.subtract(fund.getUnits(), fundChargeInUnits));
            fund.setCapital(SimulationMathematicalFunctions.multiply(fund.getUnitPrice(), fund.getUnits()));
            CollectedCharge collectedCharge = new CollectedCharge(account.getCode(), charge.getChargeDefinition(), charge.getChargeValue()).withChargedUnits(fund.getCode(), fundChargeInUnits).withChargedAmount(fundChargeAmount);
            collectedCharge.setPhase(phase);
            account.addCollectedCharge(collectedCharge);
            chargesIterator.remove();
        }
    }

    private void calculateSurrenderValueForAccount(SimulationLifeContext context, String parameterName, String chargeCode, boolean baseOnCapital) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            context.setCurrentAccount(account);
            context.setCurrentChargeDefinition(new ChargeDefinition(chargeCode, null, null, parameterName));
            BigDecimal capital = account.calculateCurrentAccountCapital();
            account.setCapital(capital);
            ChargeValueDefinition chargeValue = ChargeValueDefinition.getChargeValueDefinition(context);
            BigDecimal surrenderCharge = chargeValue.calculateAmount(account.getFirstYearPaidInAmount());
            if (baseOnCapital) {
                surrenderCharge = chargeValue.calculateAmount(capital);
            }
            account.setSurrenderCharge(surrenderCharge);
            account.setSurrenderValue(SimulationMathematicalFunctions.subtract(capital, account.getSurrenderCharge()));
        }
    }

    private void collectChargesForFunds(SimulationLifeContext context) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        ChargeDefinition chargeDefinition = context.getCurrentChargeDefinition();
        for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
            context.setCurrentFund(fund);
            this.collectChargesFromRhinoOrApi(context, chargeDefinition);
        }
    }

    private void callRhinoFunction(SimulationLifeContext context, ChargeDefinition chargeDefinition) {
        HyperonEngine paramService = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
        paramService.call(chargeDefinition.getFunctionName(), context, new Object[0]);
    }

    private void addPropotionalCharge(SimulationLifeContext context, BigDecimal amount, InvestPolicyValueSimulationContext.SuspenseAccount accountData, BigDecimal totalUnits, InvestPolicyValueSimulationContext.Fund fundData, ChargeDefinition chargeDefinition) {
        if (SimulationMathematicalFunctions.greaterThanZero(totalUnits)) {
            BigDecimal fundShare = SimulationMathematicalFunctions.divide(fundData.getUnits(), totalUnits);
            BigDecimal amountShare = SimulationMathematicalFunctions.multiply(amount, fundShare);
            BigDecimal fundChargeInUnits = SimulationMathematicalFunctions.divide(amountShare, fundData.getUnitPrice());
            accountData.addChargeToDebt(new InvestPolicyValueSimulationContext.FundCharge(fundData.getFundDefinition(), fundChargeInUnits, chargeDefinition, new ChargeValueDefinition(amount, ChargeValueDefinition.Type.AMOUNT)));
        }
    }

    private void callMethod(SimulationLifeContext context, ChargeDefinition chargeDefinition) {
        try {
            Method[] methods = RhinoSimulationLife.class.getMethods();
            Method method = null;
            for (Method methodToCheck : methods) {
                if (!methodToCheck.getName().equals(chargeDefinition.getFunctionName())) continue;
                method = methodToCheck;
                break;
            }
            if (method == null) {
                return;
            }
            method.invoke(null, context);
        }
        catch (SecurityException e) {
            LOGGER.error("No charge function " + chargeDefinition.getFunctionName(), (Throwable)e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            LOGGER.error("", (Throwable)e1);
        }
    }
}

