/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.context.DefaultContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.mp.simulation.life.invest.HyperonNoAlgorithmDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class AlgorithmProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlgorithmProvider.class);
    private static final String ORDER_COL = "stepOrder";
    private static final String STEP_NAME_COL = "stepName";
    private static final String STEP_FUNCTION_COL = "stepFunction";
    private static final String STEP_CHARGE_PHASE = "stepChargePhase";

    public List<AlgorithmStep> findAlgorithm(String parameterName, String simulationId) {
        return this.findSteps(parameterName, simulationId);
    }

    private List<AlgorithmStep> findSteps(String parameterName, String simulationId) {
        HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(simulationId);
        try {
            ParamValue pv = mpEngine.get(parameterName, new DefaultContext());
            if (pv != null && pv.size() > 0) {
                return this.extractStepsInProperOrder(pv);
            }
            throw new HyperonNoAlgorithmDefinition(String.format("No parameter %s with algorithm definition", parameterName));
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            throw new HyperonNoAlgorithmDefinition(String.format("No parameter %s with algorithm definition", parameterName));
        }
    }

    private List<AlgorithmStep> extractStepsInProperOrder(ParamValue pv) {
        ArrayList<AlgorithmStep> steps = new ArrayList<AlgorithmStep>();
        for (int i = 0; i < pv.size(); ++i) {
            steps.add(new AlgorithmStep(pv.get(i, ORDER_COL, Long.class).intValue(), pv.get(i, STEP_NAME_COL, String.class), pv.get(i, STEP_FUNCTION_COL, String.class), pv.get(i, STEP_CHARGE_PHASE, String.class)));
        }
        Collections.sort(steps);
        return steps;
    }

    public class AlgorithmStep
    implements Comparable<AlgorithmStep> {
        private final Integer order;
        private final String stepName;
        private final String stepFunction;
        private final String chargePhase;

        public AlgorithmStep(Integer order, String stepName, String stepFunction, String chargePhase) {
            this.order = order;
            this.stepName = stepName;
            this.stepFunction = stepFunction;
            this.chargePhase = chargePhase;
        }

        public void executeStep(SimulationLifeContext context) {
            this.executeRhinoStep(context, this.stepFunction);
        }

        @Override
        public int compareTo(AlgorithmStep o) {
            return this.order.compareTo(o.order);
        }

        public String getStepName() {
            return this.stepName;
        }

        public String getStepFunction() {
            return this.stepFunction;
        }

        public String getChargePhase() {
            return this.chargePhase;
        }

        private void executeRhinoStep(SimulationLifeContext context, String functionName) {
            if (StringUtils.isBlank((CharSequence)functionName)) {
                return;
            }
            HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
            context.setCurrentPhase(this.chargePhase == null ? "" : this.chargePhase);
            try {
                mpEngine.call(functionName, context, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("function name " + functionName, (Throwable)e);
                throw e;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AlgorithmStep that = (AlgorithmStep)o;
            return Objects.equals(this.order, that.order) && Objects.equals(this.stepName, that.stepName) && Objects.equals(this.stepFunction, that.stepFunction) && Objects.equals(this.chargePhase, that.chargePhase);
        }

        public int hashCode() {
            return Objects.hash(this.order, this.stepName, this.stepFunction, this.chargePhase);
        }
    }
}

