/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util.reflection;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartparam.engine.util.reflection.ReflectionsHelper;

public class ReflectionSetterInvoker {
    private final Map<Class<?>, Map<Class<?>, Setter>> setterCache = new ConcurrentHashMap();

    public boolean invokeSetter(Object setterHostObject, Object forArg) {
        Method setter = this.findSetter(setterHostObject.getClass(), forArg);
        if (setter == null) {
            return false;
        }
        ReflectionsHelper.invokerSetter(setter, setterHostObject, forArg);
        return true;
    }

    public Method findSetter(Class<?> setterHostClass, Object forArg) {
        Setter setter;
        Class<?> argClass = forArg.getClass();
        Map<Class<?>, Setter> settersMap = this.setterCache.get(setterHostClass);
        if (settersMap == null) {
            settersMap = new ConcurrentHashMap();
            this.setterCache.put(this.getClass(), settersMap);
        }
        if ((setter = settersMap.get(argClass)) == null) {
            Method method = this.lookupSetter(setterHostClass, argClass);
            setter = new Setter(method);
            settersMap.put(argClass, setter);
        }
        return setter.getMethod();
    }

    private Method lookupSetter(Class<?> setterHostClass, Class<?> propertyClass) {
        for (Class<?> clazz = setterHostClass; clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!this.isSetter(method, propertyClass)) continue;
                AccessController.doPrivileged(new AccessibleSetter(method));
                return method;
            }
        }
        return null;
    }

    private boolean isSetter(Method method, Class<?> propertyClass) {
        Class<?>[] methodArgumentTypes = method.getParameterTypes();
        return method.getReturnType() == Void.TYPE && methodArgumentTypes.length == 1 && methodArgumentTypes[0].isAssignableFrom(propertyClass);
    }

    private static final class AccessibleSetter
    implements PrivilegedAction<Object> {
        private final Method method;

        private AccessibleSetter(Method method) {
            this.method = method;
        }

        @Override
        public Object run() {
            this.method.setAccessible(true);
            return null;
        }
    }

    private static final class Setter {
        private final Method method;

        Setter(Method method) {
            this.method = method;
        }

        Method getMethod() {
            return this.method;
        }
    }
}

