/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.repository;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListRepository<V> {
    private static final Logger logger = LoggerFactory.getLogger(ListRepository.class);
    private final Class<?> containedClass;
    private final List<V> repositoryList = new ArrayList<V>();

    public ListRepository(Class<?> containedClass) {
        this.containedClass = containedClass;
    }

    public void register(V value) {
        logger.info("{} repository: registering {}", new Object[]{this.containedClass.getSimpleName(), value.getClass().getSimpleName()});
        this.repositoryList.add(value);
    }

    public void registerAll(List<V> values) {
        for (V value : values) {
            this.register(value);
        }
    }

    public List<V> getItems() {
        return new ArrayList<V>(this.repositoryList);
    }
}

