/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.prepared;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.prepared.PreparedLevel;
import org.smartparam.engine.core.prepared.PreparedParameter;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.types.string.StringType;
import pl.decerto.hyperon.runtime.helper.HyperonLevelConstants;

public final class InputValueNormalizer {
    private static final Logger logger = LoggerFactory.getLogger(InputValueNormalizer.class);

    private InputValueNormalizer() {
    }

    public static <T extends ValueHolder> String normalize(Type<T> type, String levelValue) {
        if (HyperonLevelConstants.ASTERISK.getValue().equals(levelValue)) {
            return levelValue;
        }
        if (type.getClass() == StringType.class) {
            return levelValue;
        }
        try {
            T decoded = type.decode(levelValue);
            return type.encode(decoded);
        }
        catch (RuntimeException e) {
            logger.trace(String.format("failed to normalize cell value: '%s' of type: %s", levelValue, type));
            return levelValue;
        }
    }

    public static <T extends ValueHolder> String normalize(Type<T> type, Object levelObject) {
        if (levelObject instanceof String) {
            return InputValueNormalizer.normalize(type, (String)levelObject);
        }
        T decoded = type.convert(levelObject);
        return type.encode(decoded);
    }

    public static String[] normalize(PreparedParameter param, Object[] levelValues) {
        int size = Math.min(levelValues.length, param.getInputLevelsCount());
        String[] normalized = new String[size];
        for (int i = 0; i < size; ++i) {
            PreparedLevel level = param.getLevels()[i];
            Type<?> type = level.getType();
            normalized[i] = InputValueNormalizer.normalize(type, levelValues[i]);
        }
        return normalized;
    }
}

