/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.prepared;

import org.smartparam.engine.core.decoder.StandardDecoder;
import org.smartparam.engine.core.decoder.ValueDecoder;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.matcher.Matcher;
import org.smartparam.engine.core.matcher.MatcherRepository;
import org.smartparam.engine.core.parameter.Level;
import org.smartparam.engine.core.prepared.LevelPreparer;
import org.smartparam.engine.core.prepared.PreparedLevel;
import org.smartparam.engine.core.prepared.UnknownMatcherException;
import org.smartparam.engine.core.prepared.UnknownTypeException;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.TypeRepository;

public class BasicLevelPreparer
implements LevelPreparer {
    private final MatcherRepository matcherRepository;
    private final TypeRepository typeRepository;

    public BasicLevelPreparer(MatcherRepository matcherRepository, TypeRepository typeRepository) {
        this.matcherRepository = matcherRepository;
        this.typeRepository = typeRepository;
    }

    @Override
    public PreparedLevel prepare(Level level) {
        Type<?> type = this.resolveType(level.getType(), level.getName());
        Matcher matcher = this.resolveMatcher(level.getMatcher(), level.getName(), level.isReverseMatcher());
        Function levelCreator = this.createFunctionStub(level.getLevelCreator());
        ValueDecoder decoder = level.getValueDecoder() != null ? level.getValueDecoder() : new StandardDecoder();
        return new PreparedLevel(level.getName(), level.isArray(), type, matcher, levelCreator, level.getMatchMode(), decoder);
    }

    private Type<?> resolveType(String typeCode, String levelName) {
        Type<?> type = null;
        if (typeCode != null && (type = this.typeRepository.getType(typeCode)) == null) {
            throw new UnknownTypeException(levelName, typeCode);
        }
        return type;
    }

    private Matcher resolveMatcher(String matcherCode, String levelName, boolean reverseMatcher) {
        Matcher matcher = null;
        if (matcherCode != null) {
            matcher = this.matcherRepository.getMatcher(matcherCode);
            if (matcher == null) {
                throw new UnknownMatcherException(levelName, matcherCode);
            }
            matcher.setReverse(reverseMatcher);
        }
        return matcher;
    }

    private Function createFunctionStub(String levelCreatorCode) {
        if (levelCreatorCode != null) {
            return new Function(levelCreatorCode, null);
        }
        return null;
    }
}

