/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.index;

import java.util.List;
import org.smartparam.engine.core.index.LevelNode;
import org.smartparam.engine.core.index.SearchResult;
import org.smartparam.engine.core.matcher.Matcher;
import org.smartparam.engine.core.parameter.MatchMode;
import org.smartparam.engine.core.type.Type;

public class LevelIndex<T> {
    private static final int INITIAL_PRINTER_CAPACITY = 256;
    private int levelCount;
    private LevelNode<T> root;
    private Matcher[] matchers;
    private Type<?>[] types;
    private MatchMode[] modes;

    public LevelIndex(int levelCount, Type<?>[] types, Matcher ... matchers) {
        this.levelCount = levelCount;
        this.types = new Type[levelCount];
        this.matchers = new Matcher[levelCount];
        if (types != null) {
            System.arraycopy(types, 0, this.types, 0, types.length);
        }
        if (matchers != null) {
            System.arraycopy(matchers, 0, this.matchers, 0, matchers.length);
        }
        this.root = new LevelNode(this);
    }

    public LevelIndex(int levelCount) {
        this(levelCount, null, new Matcher[0]);
    }

    public void add(String[] levelValues, T leaf) {
        this.root.add(levelValues, leaf, 0);
    }

    public List<T> find(String ... levelValues) {
        SearchResult result = new SearchResult();
        this.root.findAll(levelValues, 0, result);
        return result.getResult().isEmpty() ? null : result.getResult();
    }

    public String printTree() {
        StringBuilder sb = new StringBuilder(256);
        this.root.printNode(sb, 0);
        return sb.toString();
    }

    Matcher[] getMatchers() {
        return this.matchers;
    }

    Type<?>[] getTypes() {
        return this.types;
    }

    public Matcher getMatcher(int depth) {
        return this.matchers[depth];
    }

    public Type<?> getType(int depth) {
        return this.types[depth];
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public void setUnion(boolean ... union) {
        this.modes = new MatchMode[union.length];
        for (int i = 0; i < union.length; ++i) {
            this.modes[i] = union[i] ? MatchMode.UNION : MatchMode.STANDARD;
        }
    }

    public void setMatchModes(MatchMode ... modes) {
        this.modes = modes;
    }

    public MatchMode getMatchMode(int depth) {
        return this.modes != null && depth < this.modes.length ? this.modes[depth] : MatchMode.STANDARD;
    }
}

