/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class XmlnsBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATTRIBUTE_NAMESPACE = "namespace";
    public static final String ATTRIBUTE_ALIAS = "alias";
    public static final String PROPERTY_XMLNAMESPACES = "xmlNamespaces";
    protected Logger logger = LoggerFactory.getLogger(XmlnsBeanDefinitionParser.class);
    protected Map<URI, String> namespaces = new HashMap<URI, String>();

    public XmlnsBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        pageMetaModelFactoryBean.getPropertyValues().addPropertyValue(PROPERTY_XMLNAMESPACES, this.namespaces);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        try {
            URI namespace = new URI(element.getAttribute(ATTRIBUTE_NAMESPACE));
            String alias = element.getAttribute(ATTRIBUTE_ALIAS);
            this.logger.info("Registring XML namespace \"{}\" with alias \"{}\".", (Object)namespace, (Object)alias);
            this.namespaces.put(namespace, alias);
        }
        catch (URISyntaxException error) {
            parserContext.getReaderContext().error("Invalid XML namespace URI.", (Object)element, (Throwable)error);
        }
        return null;
    }
}

