/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.web.spring.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import pl.chilldev.web.core.markup.Generator;
import pl.chilldev.web.core.page.PageMetaModel;
import pl.chilldev.web.spring.context.PageMetaModelFactoryBean;
import pl.chilldev.web.spring.context.SpringBeansPageMetaModelResolver;
import pl.chilldev.web.tags.context.PageMetaModelContextUtils;
import pl.chilldev.web.tags.context.PageMetaModelResolver;

public class HandlePageModelBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ATTRIBUTE_XHTML = "xhtml";
    public static final String METHOD_CREATEPAGEMETAMODEL = "createPageMetaModel";
    protected Logger logger = LoggerFactory.getLogger(HandlePageModelBeanDefinitionParser.class);
    protected BeanDefinition pageMetaModelFactoryBean;

    public HandlePageModelBeanDefinitionParser(BeanDefinition pageMetaModelFactoryBean) {
        this.pageMetaModelFactoryBean = pageMetaModelFactoryBean;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        GenericBeanDefinition pageMetaModelBean = new GenericBeanDefinition();
        pageMetaModelBean.setBeanClass(PageMetaModel.class);
        pageMetaModelBean.setScope("request");
        pageMetaModelBean.setFactoryBeanName(PageMetaModelFactoryBean.class.getName());
        pageMetaModelBean.setFactoryMethodName(METHOD_CREATEPAGEMETAMODEL);
        parserContext.getRegistry().registerBeanDefinition(PageMetaModel.class.getName(), (BeanDefinition)pageMetaModelBean);
        parserContext.getRegistry().registerBeanDefinition(PageMetaModelFactoryBean.class.getName(), this.pageMetaModelFactoryBean);
        if (element.hasAttribute(ATTRIBUTE_XHTML)) {
            boolean xhtml = element.getAttribute(ATTRIBUTE_XHTML).equals("true");
            GenericBeanDefinition generatorBean = new GenericBeanDefinition();
            generatorBean.setBeanClass(Generator.class);
            this.logger.info("Setting markup generator XHTML mode to {}.", (Object)xhtml);
            ConstructorArgumentValues arguments = generatorBean.getConstructorArgumentValues();
            arguments.addGenericArgumentValue((Object)xhtml);
            parserContext.getRegistry().registerBeanDefinition(Generator.class.getName(), (BeanDefinition)generatorBean);
            arguments = pageMetaModelBean.getConstructorArgumentValues();
            arguments.addGenericArgumentValue((Object)new RuntimeBeanReference(Generator.class.getName()));
        }
        PageMetaModelContextUtils.setPageMetaModelResolver((PageMetaModelResolver)new SpringBeansPageMetaModelResolver());
        return null;
    }
}

