/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import groovy.lang.Closure;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.util.ConfigureUtil;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Builder;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.io.ZipFileTarArchive;
import org.springframework.boot.gradle.tasks.bundling.CacheSpec;
import org.springframework.boot.gradle.tasks.bundling.DockerSpec;
import org.springframework.boot.gradle.util.VersionExtractor;
import org.springframework.util.StringUtils;

public class BootBuildImage
extends DefaultTask {
    private static final String BUILDPACK_JVM_VERSION_KEY = "BP_JVM_VERSION";
    private final String projectName;
    private final Property<String> projectVersion;
    private RegularFileProperty archiveFile;
    private Property<JavaVersion> targetJavaVersion;
    private String imageName;
    private String builder;
    private String runImage;
    private Map<String, String> environment = new HashMap<String, String>();
    private boolean cleanCache;
    private boolean verboseLogging;
    private PullPolicy pullPolicy;
    private boolean publish;
    private final ListProperty<String> buildpacks;
    private final ListProperty<String> bindings;
    private String network;
    private final ListProperty<String> tags;
    private final CacheSpec buildCache = new CacheSpec();
    private final CacheSpec launchCache = new CacheSpec();
    private final DockerSpec docker = new DockerSpec();

    public BootBuildImage() {
        this.archiveFile = this.getProject().getObjects().fileProperty();
        this.targetJavaVersion = this.getProject().getObjects().property(JavaVersion.class);
        this.projectName = this.getProject().getName();
        this.projectVersion = this.getProject().getObjects().property(String.class);
        Project project = this.getProject();
        this.projectVersion.set(this.getProject().provider(() -> project.getVersion().toString()));
        this.buildpacks = this.getProject().getObjects().listProperty(String.class);
        this.bindings = this.getProject().getObjects().listProperty(String.class);
        this.tags = this.getProject().getObjects().listProperty(String.class);
    }

    @Input
    public RegularFileProperty getArchiveFile() {
        return this.archiveFile;
    }

    @Input
    @Optional
    public Property<JavaVersion> getTargetJavaVersion() {
        return this.targetJavaVersion;
    }

    @Input
    @Optional
    public String getImageName() {
        return this.determineImageReference().toString();
    }

    @Option(option="imageName", description="The name of the image to generate")
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    @Input
    @Optional
    public String getBuilder() {
        return this.builder;
    }

    @Option(option="builder", description="The name of the builder image to use")
    public void setBuilder(String builder) {
        this.builder = builder;
    }

    @Input
    @Optional
    public String getRunImage() {
        return this.runImage;
    }

    @Option(option="runImage", description="The name of the run image to use")
    public void setRunImage(String runImage) {
        this.runImage = runImage;
    }

    @Input
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void environment(String name, String value) {
        this.environment.put(name, value);
    }

    public void environment(Map<String, String> entries) {
        this.environment.putAll(entries);
    }

    @Input
    public boolean isCleanCache() {
        return this.cleanCache;
    }

    @Option(option="cleanCache", description="Clean caches before packaging")
    public void setCleanCache(boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    @Input
    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    @Input
    @Optional
    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Option(option="pullPolicy", description="The image pull policy")
    public void setPullPolicy(PullPolicy pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    @Input
    public boolean isPublish() {
        return this.publish;
    }

    @Option(option="publishImage", description="Publish the built image to a registry")
    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    @Input
    @Optional
    public List<String> getBuildpacks() {
        return (List)this.buildpacks.getOrNull();
    }

    public void setBuildpacks(List<String> buildpacks) {
        this.buildpacks.set(buildpacks);
    }

    public void buildpack(String buildpack) {
        this.buildpacks.add((Object)buildpack);
    }

    public void buildpacks(List<String> buildpacks) {
        this.buildpacks.addAll(buildpacks);
    }

    @Input
    @Optional
    public List<String> getBindings() {
        return (List)this.bindings.getOrNull();
    }

    public void setBindings(List<String> bindings) {
        this.bindings.set(bindings);
    }

    public void binding(String binding) {
        this.bindings.add((Object)binding);
    }

    public void bindings(List<String> bindings) {
        this.bindings.addAll(bindings);
    }

    @Input
    @Optional
    public List<String> getTags() {
        return (List)this.tags.getOrNull();
    }

    public void setTags(List<String> tags) {
        this.tags.set(tags);
    }

    public void tag(String tag) {
        this.tags.add((Object)tag);
    }

    public void tags(List<String> tags) {
        this.tags.addAll(tags);
    }

    @Input
    @Optional
    public String getNetwork() {
        return this.network;
    }

    @Option(option="network", description="Connect detect and build containers to network")
    public void setNetwork(String network) {
        this.network = network;
    }

    @Nested
    @Optional
    public CacheSpec getBuildCache() {
        return this.buildCache;
    }

    public void buildCache(Action<CacheSpec> action) {
        action.execute((Object)this.buildCache);
    }

    public void buildCache(Closure<?> closure) {
        this.buildCache((Action<CacheSpec>)ConfigureUtil.configureUsing(closure));
    }

    @Nested
    @Optional
    public CacheSpec getLaunchCache() {
        return this.launchCache;
    }

    public void launchCache(Action<CacheSpec> action) {
        action.execute((Object)this.launchCache);
    }

    public void launchCache(Closure<?> closure) {
        this.launchCache((Action<CacheSpec>)ConfigureUtil.configureUsing(closure));
    }

    @Nested
    public DockerSpec getDocker() {
        return this.docker;
    }

    public void docker(Action<DockerSpec> action) {
        action.execute((Object)this.docker);
    }

    public void docker(Closure<?> closure) {
        this.docker((Action<DockerSpec>)ConfigureUtil.configureUsing(closure));
    }

    @TaskAction
    void buildImage() throws DockerEngineException, IOException {
        Builder builder = new Builder(this.docker.asDockerConfiguration());
        BuildRequest request = this.createRequest();
        builder.build(request);
    }

    BuildRequest createRequest() {
        return this.customize(BuildRequest.of((ImageReference)this.determineImageReference(), owner -> new ZipFileTarArchive(((RegularFile)this.archiveFile.get()).getAsFile(), owner)));
    }

    private ImageReference determineImageReference() {
        if (StringUtils.hasText((String)this.imageName)) {
            return ImageReference.of((String)this.imageName);
        }
        ImageName imageName = ImageName.of((String)this.projectName);
        if ("unspecified".equals(this.projectVersion.get())) {
            return ImageReference.of((ImageName)imageName);
        }
        return ImageReference.of((ImageName)imageName, (String)((String)this.projectVersion.get()));
    }

    private BuildRequest customize(BuildRequest request) {
        request = this.customizeBuilder(request);
        request = this.customizeRunImage(request);
        request = this.customizeEnvironment(request);
        request = this.customizeCreator(request);
        request = request.withCleanCache(this.cleanCache);
        request = request.withVerboseLogging(this.verboseLogging);
        request = this.customizePullPolicy(request);
        request = this.customizePublish(request);
        request = this.customizeBuildpacks(request);
        request = this.customizeBindings(request);
        request = this.customizeTags(request);
        request = this.customizeCaches(request);
        request = request.withNetwork(this.network);
        return request;
    }

    private BuildRequest customizeBuilder(BuildRequest request) {
        if (StringUtils.hasText((String)this.builder)) {
            return request.withBuilder(ImageReference.of((String)this.builder));
        }
        return request;
    }

    private BuildRequest customizeRunImage(BuildRequest request) {
        if (StringUtils.hasText((String)this.runImage)) {
            return request.withRunImage(ImageReference.of((String)this.runImage));
        }
        return request;
    }

    private BuildRequest customizeEnvironment(BuildRequest request) {
        if (this.environment != null && !this.environment.isEmpty()) {
            request = request.withEnv(this.environment);
        }
        if (this.targetJavaVersion.isPresent() && !request.getEnv().containsKey(BUILDPACK_JVM_VERSION_KEY)) {
            request = request.withEnv(BUILDPACK_JVM_VERSION_KEY, this.translateTargetJavaVersion());
        }
        return request;
    }

    private BuildRequest customizeCreator(BuildRequest request) {
        String springBootVersion = VersionExtractor.forClass(BootBuildImage.class);
        if (StringUtils.hasText((String)springBootVersion)) {
            return request.withCreator(Creator.withVersion((String)springBootVersion));
        }
        return request;
    }

    private BuildRequest customizePullPolicy(BuildRequest request) {
        if (this.pullPolicy != null) {
            request = request.withPullPolicy(this.pullPolicy);
        }
        return request;
    }

    private BuildRequest customizePublish(BuildRequest request) {
        boolean publishRegistryAuthNotConfigured;
        boolean bl = publishRegistryAuthNotConfigured = this.docker == null || this.docker.getPublishRegistry() == null || this.docker.getPublishRegistry().hasEmptyAuth();
        if (this.publish && publishRegistryAuthNotConfigured) {
            throw new GradleException("Publishing an image requires docker.publishRegistry to be configured");
        }
        request = request.withPublish(this.publish);
        return request;
    }

    private BuildRequest customizeBuildpacks(BuildRequest request) {
        List buildpacks = (List)this.buildpacks.getOrNull();
        if (buildpacks != null && !buildpacks.isEmpty()) {
            return request.withBuildpacks(buildpacks.stream().map(BuildpackReference::of).collect(Collectors.toList()));
        }
        return request;
    }

    private BuildRequest customizeBindings(BuildRequest request) {
        List bindings = (List)this.bindings.getOrNull();
        if (bindings != null && !bindings.isEmpty()) {
            return request.withBindings(bindings.stream().map(Binding::of).collect(Collectors.toList()));
        }
        return request;
    }

    private BuildRequest customizeTags(BuildRequest request) {
        List tags = (List)this.tags.getOrNull();
        if (tags != null && !tags.isEmpty()) {
            return request.withTags(tags.stream().map(ImageReference::of).collect(Collectors.toList()));
        }
        return request;
    }

    private BuildRequest customizeCaches(BuildRequest request) {
        if (this.buildCache.asCache() != null) {
            request = request.withBuildCache(this.buildCache.asCache());
        }
        if (this.launchCache.asCache() != null) {
            request = request.withLaunchCache(this.launchCache.asCache());
        }
        return request;
    }

    private String translateTargetJavaVersion() {
        return ((JavaVersion)this.targetJavaVersion.get()).getMajorVersion() + ".*";
    }
}

