/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.tools;

import org.apache.commons.lang.StringUtils;

public class XMLToString {
    private String m_elementName;
    private StringBuffer m_buffer = new StringBuffer();
    private StringBuffer m_innerBuffer;

    public XMLToString(String elementName) {
        this.m_buffer.append('<').append(elementName);
        this.m_elementName = elementName;
    }

    public void addAttribut(String name, String value) {
        if (name != null && name.length() > 0 && value != null) {
            this.m_buffer.append(' ').append(name).append("='").append(value).append("'");
        }
    }

    public void addFilledAttribut(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            this.m_buffer.append(' ').append(name).append("='").append(value).append("'");
        }
    }

    public void addTextNode(String text) {
        if (text != null && text.length() > 0) {
            if (this.m_innerBuffer == null) {
                this.m_innerBuffer = new StringBuffer();
            }
            this.m_innerBuffer.append(XMLToString.convert(text));
        }
    }

    public void addStringElement(String stringElement) {
        if (stringElement != null) {
            if (this.m_innerBuffer == null) {
                this.m_innerBuffer = new StringBuffer();
            }
            this.m_innerBuffer.append(stringElement);
        }
    }

    public void addElement(XMLToString xmlToString) {
        if (xmlToString != null) {
            if (this.m_innerBuffer == null) {
                this.m_innerBuffer = new StringBuffer();
            }
            this.m_innerBuffer.append(xmlToString.toStringBuffer());
        }
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_innerBuffer != null) {
            buffer.append(this.m_buffer).append('>').append(this.m_innerBuffer).append("</").append(this.m_elementName).append('>');
        } else {
            buffer.append(this.m_buffer).append("/>");
        }
        return buffer;
    }

    private static final String convert(String s) {
        s = StringUtils.replace((String)s, (String)"&", (String)"&amp;");
        s = StringUtils.replace((String)s, (String)"<", (String)"&lt;");
        s = StringUtils.replace((String)s, (String)">", (String)"&gt;");
        return s;
    }
}

