/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.tools;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.logger.Logger;

public class InputStreamDebugger
extends InputStream {
    private InputStream m_is;
    private Logger m_logger;
    private long m_id;

    public InputStreamDebugger(InputStream is, Logger logger, long id) {
        this.m_is = is;
        this.m_logger = logger;
        this.m_id = id;
    }

    public int available() throws IOException {
        return this.m_is.available();
    }

    public void close() throws IOException {
        this.m_is.close();
    }

    public void mark(int readlimit) {
        this.m_is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.m_is.markSupported();
    }

    public int read() throws IOException {
        int b = this.m_is.read();
        this.m_logger.info("Input (" + this.m_id + "): " + new Character((char)b));
        return b;
    }

    public int read(byte[] b) throws IOException {
        int i = this.m_is.read(b);
        this.m_logger.info("Input (" + this.m_id + "): " + new String(b, 0, i));
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.m_is.read(b, off, len);
        this.m_logger.info("Input (" + this.m_id + "): " + new String(b, off, i));
        return i;
    }

    public void reset() throws IOException {
        this.m_is.reset();
    }

    public long skip(long n) throws IOException {
        return this.m_is.skip(n);
    }
}

