/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.session;

import java.util.Map;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SessionsManagerImpl
extends AbstractLogEnabled
implements SessionsManager,
Serviceable {
    private Map m_sessionSetByHostName;
    private ServiceManager m_serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public IMServerSession getNewServerSession() throws Exception {
        IMServerSession session = (IMServerSession)this.m_serviceManager.lookup("IMServerSession");
        return session;
    }

    public IMClientSession getNewClientSession() throws Exception {
        IMClientSession session = (IMClientSession)this.m_serviceManager.lookup("IMClientSession");
        return session;
    }

    public void release(IMSession session) {
        if (session != null) {
            try {
                if (!session.isClosed()) {
                    session.close();
                } else {
                    this.getLogger().warn("Session " + session.getId() + " already diposed");
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Session " + session.getId() + " release failure " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

