/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.session;

import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.session.AbstractIMSession;
import net.java.dev.openim.session.IMServerSession;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class IMServerSessionImpl
extends AbstractIMSession
implements IMServerSession,
Initializable,
Serviceable,
Configurable {
    private ServerParameters m_serverParameters;
    private ServiceManager m_serviceManager;
    private Configuration m_configuration;
    private String m_remoteHostname;
    private volatile boolean m_dialbackValid;
    private volatile String m_dialbackValue;
    private IMServerSession m_twinSession;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
        this.m_defaultEncoding = configuration.getChild("default-encoding").getValue("UTF-8");
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        this.m_dialbackValid = false;
        this.m_disposed = new Boolean(false);
        Long l = AbstractIMSession.m_lastSessionId;
        synchronized (l) {
            this.m_sessionId = AbstractIMSession.m_lastSessionId;
            AbstractIMSession.m_lastSessionId = new Long(this.m_sessionId + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.getLogger().debug("Closing session id " + this.getId());
        Boolean bl = this.m_disposed;
        synchronized (bl) {
            this.m_dialbackValid = false;
            this.m_dialbackValue = null;
            try {
                if (this.m_twinSession != null) {
                    this.m_twinSession.setTwinSession(null);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage1): " + e.getMessage(), (Throwable)e);
            }
            try {
                this.writeOutputStream("</stream:stream>");
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage2): " + e.getMessage());
            }
            try {
                this.getLogger().debug("Session " + this.m_sessionId + " closed");
                if (this.m_socket != null && !this.m_socket.isClosed()) {
                    this.m_socket.close();
                    this.m_outputStreamWriter.close();
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage3): " + e.getMessage(), (Throwable)e);
            }
            this.getLogger().debug("Session " + this.m_sessionId + " disposed ");
        }
        this.m_disposed = new Boolean(true);
    }

    public boolean getDialbackValid() {
        return this.m_dialbackValid;
    }

    public void setDialbackValid(boolean value) {
        int ctype = this.getConnectionType();
        if (ctype == 3 || ctype == 2) {
            this.m_dialbackValid = value;
        }
    }

    public String getDialbackValue() {
        return this.m_dialbackValue;
    }

    public void setDialbackValue(String dialback) {
        this.m_dialbackValue = dialback;
    }

    public IMServerSession getTwinSession() {
        return this.m_twinSession;
    }

    public void setTwinSession(IMServerSession session) {
        this.m_twinSession = session;
    }

    public final String getRemoteHostname() {
        return this.m_remoteHostname;
    }

    public final void setRemoteHostname(String remoteHostname) {
        this.m_remoteHostname = remoteHostname;
    }

    public int getConnectionType() {
        int type = 0;
        if (this.m_socket != null) {
            if (this.m_socket.getLocalPort() == this.m_serverParameters.getLocalServerPort() || this.m_socket.getLocalPort() == this.m_serverParameters.getLocalSSLServerPort()) {
                type = 3;
            } else if (this.m_socket.getPort() == this.m_serverParameters.getRemoteServerPort()) {
                type = 2;
            }
        }
        return type;
    }
}

