/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.session;

import java.util.List;
import net.java.dev.openim.IMPresenceHolder;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.UsersManager;
import net.java.dev.openim.data.jabber.IMPresence;
import net.java.dev.openim.data.jabber.IMPresenceImpl;
import net.java.dev.openim.data.jabber.IMRosterItem;
import net.java.dev.openim.data.jabber.User;
import net.java.dev.openim.session.AbstractIMSession;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class IMClientSessionImpl
extends AbstractIMSession
implements IMClientSession,
Initializable,
Serviceable,
Configurable {
    private ServerParameters m_serverParameters;
    private ServiceManager m_serviceManager;
    private Configuration m_configuration;
    private UsersManager m_usersManager;
    private User m_user;
    private IMPresence m_presence;
    private IMPresenceHolder m_presenceHolder;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
        this.m_defaultEncoding = configuration.getChild("default-encoding").getValue("UTF-8");
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_usersManager = (UsersManager)this.m_serviceManager.lookup("UsersManager");
        this.m_presenceHolder = (IMPresenceHolder)serviceManager.lookup("IMPresenceHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        this.m_disposed = new Boolean(false);
        Long l = AbstractIMSession.m_lastSessionId;
        synchronized (l) {
            this.m_sessionId = AbstractIMSession.m_lastSessionId;
            AbstractIMSession.m_lastSessionId = new Long(this.m_sessionId + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.getLogger().debug("Closing session id " + this.getId());
        Boolean bl = this.m_disposed;
        synchronized (bl) {
            try {
                if (this.m_user != null && this.getConnectionType() == 1) {
                    IMPresence presence = this.m_presenceHolder.removePresence(this.m_user.getJIDAndRessource());
                    this.getLogger().debug("Remove presence jid " + this.m_user.getJIDAndRessource());
                    presence = new IMPresenceImpl();
                    presence.setFrom(this.m_user.getJIDAndRessource());
                    presence.setType("unavailable");
                    presence.setStatus("Disconnected");
                    List rosterList = this.m_user.getRosterItemList();
                    if (rosterList != null) {
                        int l = rosterList.size();
                        for (int i = 0; i < l; ++i) {
                            IMRosterItem item = (IMRosterItem)rosterList.get(i);
                            this.getLogger().debug("Item " + item);
                            IMPresence localPresence = (IMPresence)presence.clone();
                            localPresence.setTo(item.getJID());
                            if (this.m_router == null) continue;
                            this.m_router.route((IMSession)this, (Transitable)localPresence);
                        }
                    }
                }
                if (this.m_router != null) {
                    this.m_router.unregisterSession((IMClientSession)this);
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage1): " + e.getMessage(), (Throwable)e);
            }
            try {
                this.writeOutputStream("</stream:stream>");
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage2): " + e.getMessage());
            }
            try {
                this.getLogger().debug("Session " + this.m_sessionId + " closed");
                if (this.m_socket != null && !this.m_socket.isClosed()) {
                    this.m_socket.close();
                    this.m_outputStreamWriter.close();
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Session dispose failed (stage3): " + e.getMessage(), (Throwable)e);
            }
            this.getLogger().debug("Session " + this.m_sessionId + " disposed ");
        }
        this.m_disposed = new Boolean(true);
    }

    public final void setUser(User user) {
        this.m_user = user;
    }

    public final User getUser() {
        return this.m_user;
    }

    public IMPresence getPresence() {
        return this.m_presence;
    }

    public void setPresence(IMPresence presence) {
        this.m_presence = presence;
    }

    public int getConnectionType() {
        return 1;
    }
}

