/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.session;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Socket;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class AbstractIMSession
extends AbstractLogEnabled
implements IMSession {
    protected String m_defaultEncoding;
    protected OutputStreamWriter m_outputStreamWriter;
    private XmlPullParser m_xpp;
    protected Socket m_socket;
    private String m_encoding;
    protected IMRouter m_router;
    protected volatile Boolean m_disposed;
    protected long m_sessionId;
    protected static Long m_lastSessionId = new Long(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean value = false;
        if (this.m_disposed != null) {
            Boolean bl = this.m_disposed;
            synchronized (bl) {
                value = this.m_disposed;
            }
        }
        return value;
    }

    public void setup(Socket socket) throws Exception {
        this.m_socket = socket;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.m_xpp = factory.newPullParser();
        DataInputStream is = new DataInputStream(socket.getInputStream());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)is, this.m_defaultEncoding);
        this.m_xpp.setInput((Reader)inputStreamReader);
        DataOutputStream os = new DataOutputStream(socket.getOutputStream());
        this.m_outputStreamWriter = new OutputStreamWriter((OutputStream)os, this.m_defaultEncoding);
        this.getLogger().debug("Starting session: " + this.m_sessionId + " with encoding " + this.m_encoding);
    }

    public final XmlPullParser getXmlPullParser() {
        return this.m_xpp;
    }

    public final long getId() {
        return this.m_sessionId;
    }

    public final String getEncoding() {
        return this.m_defaultEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeOutputStream(String s) throws IOException {
        this.getLogger().debug("Output (" + this.m_sessionId + "/" + this.getConnectionType() + "): " + s);
        if (s != null && this.m_outputStreamWriter != null) {
            if (!this.m_socket.isClosed() && this.m_socket.isConnected()) {
                OutputStreamWriter outputStreamWriter = this.m_outputStreamWriter;
                synchronized (outputStreamWriter) {
                    this.m_outputStreamWriter.write(s);
                    this.m_outputStreamWriter.flush();
                }
            } else {
                throw new IOException("Output socket closed or not connected");
            }
        }
    }

    public final IMRouter getRouter() {
        return this.m_router;
    }

    public final void setRouter(IMRouter router) {
        this.m_router = router;
    }

    public final String toString() {
        return "I: " + this.getId();
    }

    public final int hashCode() {
        Long sessionL = new Long(this.m_sessionId);
        return sessionL.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof IMSession) {
            result = obj == this;
        }
        return result;
    }

    public abstract /* synthetic */ int getConnectionType();

    public abstract /* synthetic */ void close();
}

