/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.server.dialback;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.jabber.server.dialback.Verify;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class VerifyImpl
extends DefaultSessionProcessor
implements Verify {
    private SessionsManager m_sessionsManager;
    private String m_dialbackValue;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        super.service(serviceManager);
    }

    public void process(IMSession session, Object context) throws Exception {
        IMServerSession serverSession = (IMServerSession)session;
        XmlPullParser xpp = session.getXmlPullParser();
        String type = xpp.getAttributeValue("", "type");
        String from = xpp.getAttributeValue("", "from");
        String to = xpp.getAttributeValue("", "to");
        String id = xpp.getAttributeValue("", "id");
        super.process(session, context);
        this.getLogger().debug("Got m_dialbackValue " + this.m_dialbackValue);
        if ("valid".equals(type)) {
            String s = "<db:result to='" + from + "' from='" + to + "' type='valid' id='" + id + "'/>";
            this.getLogger().debug("Verfication valid " + s);
            serverSession.getTwinSession().writeOutputStream(s);
        } else if (this.m_dialbackValue != null) {
            IMServerSession local2remoteSession = session.getRouter().getS2SConnectorManager().getCurrentRemoteSession(from);
            if (local2remoteSession != null && this.m_dialbackValue.equals(local2remoteSession.getDialbackValue())) {
                this.getLogger().debug("Verification valid from " + from + " to " + to + " id " + id + " dialbackId " + this.m_dialbackValue);
                String s = "<db:verify from='" + to + "' " + "to='" + from + "' " + "id='" + id + "' " + "type='valid'/>";
                session.writeOutputStream(s);
            } else if (local2remoteSession == null) {
                this.getLogger().warn("Abnormal: local2remoteSession null");
            } else {
                this.getLogger().warn("Unvalid Dialback " + this.m_dialbackValue + " expected " + local2remoteSession.getDialbackValue());
            }
        }
    }

    public void processText(IMSession session, Object context) throws Exception {
        this.m_dialbackValue = session.getXmlPullParser().getText().trim();
    }
}

