/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.server.dialback;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.jabber.server.dialback.Result;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class ResultImpl
extends DefaultSessionProcessor
implements Result {
    private String m_dialbackValue;
    private SessionsManager m_sessionsManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        super.service(serviceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(IMSession session, Object context) throws Exception {
        IMServerSession serverSession = (IMServerSession)session;
        XmlPullParser xpp = session.getXmlPullParser();
        String from = xpp.getAttributeValue("", "from");
        String type = xpp.getAttributeValue("", "type");
        if (from != null && from.length() > 0) {
            serverSession.setRemoteHostname(from);
        }
        super.process(session, context);
        if ("valid".equals(type)) {
            this.getLogger().debug("Result valid from " + from);
            serverSession.setDialbackValid(true);
            IMSession iMSession = session;
            synchronized (iMSession) {
                session.notifyAll();
            }
        } else if (this.m_dialbackValue != null) {
            this.getLogger().debug("Verify " + from + " dialback " + this.m_dialbackValue);
            if (serverSession.getTwinSession() == null) {
                session.getRouter().getS2SConnectorManager().verifyRemoteHost(from, this.m_dialbackValue, Long.toString(session.getId()), serverSession);
            }
        }
    }

    public void processText(IMSession session, Object context) throws Exception {
        this.m_dialbackValue = session.getXmlPullParser().getText().trim();
    }
}

