/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.server;

import java.util.Collection;
import java.util.Iterator;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMPresenceHolder;
import net.java.dev.openim.SubscriptionManager;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.IMPresence;
import net.java.dev.openim.data.jabber.IMPresenceImpl;
import net.java.dev.openim.jabber.server.Presence;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.xmlpull.v1.XmlPullParser;

public class PresenceImpl
extends DefaultSessionProcessor
implements Presence,
ThreadSafe {
    private IMPresenceHolder m_presenceHolder;
    private SubscriptionManager m_subscriptionManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this.m_presenceHolder = (IMPresenceHolder)serviceManager.lookup("IMPresenceHolder");
        this.m_subscriptionManager = (SubscriptionManager)serviceManager.lookup("SubscriptionManager");
    }

    public void process(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String type = xpp.getAttributeValue("", "type");
        String to = xpp.getAttributeValue("", "to");
        String from = xpp.getAttributeValue("", "from");
        IMPresenceImpl presence = new IMPresenceImpl();
        presence.setType(type);
        presence.setTo(to);
        presence.setFrom(from);
        super.process(session, presence);
        this.getLogger().debug("Got presence (to " + to + "): " + presence);
        if (to == null || to.length() == 0) {
            this.getLogger().debug("To is not specified, what should we do?");
        } else {
            String presenceType = presence.getType();
            if ("probe".equals(presenceType)) {
                this.getLogger().info("Probed from " + from + " to " + to);
                Collection col = this.m_presenceHolder.getPresence(to);
                if (col != null && !col.isEmpty()) {
                    Iterator iter = col.iterator();
                    while (iter.hasNext()) {
                        IMPresence localPresence = (IMPresence)iter.next();
                        localPresence = (IMPresence)localPresence.clone();
                        localPresence.setTo(from);
                        session.getRouter().route(session, (Transitable)localPresence);
                    }
                } else {
                    IMPresenceImpl localPresence = new IMPresenceImpl();
                    localPresence.setType("unavailable");
                    localPresence.setFrom(to);
                    localPresence.setTo(from);
                    session.getRouter().route(session, (Transitable)localPresence);
                }
            } else {
                IMPresence localPresence = (IMPresence)presence.clone();
                this.m_subscriptionManager.process(session, localPresence);
            }
        }
    }
}

