/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.vcardtemp;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.storage.PrivateRepositoryHolder;
import net.java.dev.openim.jabber.iq.vcardtemp.VCard;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.tools.JIDParser;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class VCardImpl
extends DefaultSessionProcessor
implements VCard {
    private ServerParameters m_serverParameters;
    private PrivateRepositoryHolder m_privateRepository;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_privateRepository = (PrivateRepositoryHolder)serviceManager.lookup("PrivateRepositoryHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
    }

    public void process(IMSession session, Object context) throws Exception {
        String type = ((IMIq)context).getType();
        if ("get".equals(type)) {
            this.get(session, context);
        } else if ("set".equals(type)) {
            this.set((IMClientSession)session, context);
        } else if ("result".equals(type)) {
            this.result(session, context);
        }
    }

    private void get(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String vcardname = xpp.getNamespace() + ':' + xpp.getName();
        String iqId = ((IMIq)context).getId();
        String to = ((IMIq)context).getTo();
        String from = ((IMIq)context).getFrom();
        if (to == null || to.length() == 0) {
            to = ((IMClientSession)session).getUser().getJID();
        }
        if (from == null || from.length() == 0) {
            from = ((IMClientSession)session).getUser().getJID();
        }
        IMIq iq = null;
        if (this.m_serverParameters.getHostNameList().contains(JIDParser.getHostname(to))) {
            String data = this.m_privateRepository.getData(to, vcardname.toLowerCase());
            if (data == null) {
                data = "<vCard xmlns='vcard-temp'/>";
            }
            this.getLogger().debug("Get " + to + "/" + vcardname + " vcard: " + data);
            iq = new IMIq();
            iq.setFrom(to);
            iq.setTo(from);
            iq.setId(iqId);
            iq.setType("result");
            iq.setStringData(data);
        } else {
            iq = new IMIq();
            iq.setFrom(from);
            iq.setTo(to);
            iq.setId(iqId);
            iq.setType("get");
            iq.setStringData("<vCard xmlns='vcard-temp'/>");
        }
        session.getRouter().route(session, (Transitable)iq);
        this.skip(xpp);
    }

    private void set(IMClientSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String vcardname = xpp.getNamespace() + ':' + xpp.getName();
        String data = this.serialize(xpp).toString();
        this.getLogger().debug("Set " + session.getUser().getJID() + "/" + vcardname + " vcard: " + data);
        if (data != null) {
            this.m_privateRepository.setData(session.getUser().getJID(), vcardname.toLowerCase(), data);
        }
        String iqId = ((IMIq)context).getId();
        String to = ((IMIq)context).getTo();
        String from = ((IMIq)context).getFrom();
        String s = "<iq type='result'";
        s = s + " from='" + to + "'";
        s = s + " to='" + from + "'";
        s = s + " id='" + iqId + "'/>";
        session.writeOutputStream(s);
    }

    private void result(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String to = ((IMIq)context).getTo();
        if (this.m_serverParameters.getHostNameList().contains(JIDParser.getHostname(to))) {
            String iqId = ((IMIq)context).getId();
            String from = ((IMIq)context).getFrom();
            String data = this.serialize(xpp).toString();
            IMIq iq = new IMIq();
            iq.setFrom(from);
            iq.setTo(to);
            iq.setId(iqId);
            iq.setType("result");
            iq.setStringData(data);
            session.getRouter().route(session, (Transitable)iq);
        } else {
            this.getLogger().warn("Abnormal result for remote delivery?");
            this.skip(xpp);
        }
    }
}

