/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.search;

import java.util.List;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.jabber.iq.search.Query;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class QueryImpl
extends DefaultSessionProcessor
implements Query {
    private ServerParameters m_serverParameters;
    private AccountRepositoryHolder m_accountHolder;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        this.m_accountHolder = (AccountRepositoryHolder)serviceManager.lookup("AccountRepositoryHolder");
    }

    public void process(IMSession session, Object context) throws Exception {
        IMClientSession clientSession = (IMClientSession)session;
        String type = ((IMIq)context).getType();
        if ("get".equals(type)) {
            this.get(clientSession, context);
        } else if ("set".equals(type)) {
            this.set(clientSession, context);
        }
    }

    private void get(IMClientSession session, Object context) throws Exception {
        String iqId = ((IMIq)context).getId();
        String s = "<iq type='result'";
        s = s + " from='" + this.m_serverParameters.getHostName() + "'";
        s = s + " to='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " id='" + iqId + "'";
        s = s + ">";
        s = s + "<query xmlns='jabber:iq:search'>";
        s = s + "<nick/>";
        s = s + "<instructions>Fill in one or more fields to search for any matching Jabber users.</instructions>";
        s = s + "</query></iq>";
        session.writeOutputStream(s);
    }

    private void set(IMClientSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String iqId = ((IMIq)context).getId();
        xpp.nextTag();
        String searchText = xpp.nextText();
        xpp.nextTag();
        this.getLogger().debug("Search for account name " + searchText);
        List list = this.m_accountHolder.getAccountList(searchText);
        String s = "<iq type='result'";
        s = s + " from='" + this.m_serverParameters.getHostName() + "'";
        s = s + " to='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " id='" + iqId + "'";
        s = s + ">";
        if ((long)list.size() > 0L) {
            s = s + "<query xmlns='jabber:iq:search'>";
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                Account account = (Account)list.get(i);
                s = s + "<item jid='" + account.getName() + '@' + this.m_serverParameters.getHostName() + "'>";
                s = s + "<first>" + account.getName() + "</first>";
                s = s + "<last>" + account.getName() + "</last>";
                s = s + "<nick>" + account.getName() + "</nick>";
                s = s + "<email>" + account.getName() + '@' + this.m_serverParameters.getHostName() + "</email>";
                s = s + "</item>";
            }
            s = s + "</query>";
        } else {
            s = s + "<query xmlns='jabber:iq:search'/>";
        }
        s = s + "</iq>";
        session.writeOutputStream(s);
    }
}

