/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMPresenceHolder;
import net.java.dev.openim.SubscriptionManager;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.jabber.IMPresence;
import net.java.dev.openim.data.jabber.IMPresenceImpl;
import net.java.dev.openim.data.jabber.IMRosterItem;
import net.java.dev.openim.jabber.iq.roster.Query;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class QueryImpl
extends DefaultSessionProcessor
implements Query {
    private IMPresenceHolder m_presenceHolder;
    private SubscriptionManager m_subscriptionManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_presenceHolder = (IMPresenceHolder)serviceManager.lookup("IMPresenceHolder");
        this.m_subscriptionManager = (SubscriptionManager)serviceManager.lookup("SubscriptionManager");
        super.service(serviceManager);
    }

    public void process(IMSession session, Object context) throws Exception {
        String iqId = ((IMIq)context).getId();
        String type = ((IMIq)context).getType();
        this.getLogger().debug("Roster query type = " + type + " iqId " + iqId);
        if ("get".equals(type)) {
            this.get(iqId, (IMClientSession)session);
        } else if ("set".equals(type)) {
            this.set(iqId, (IMClientSession)session);
        }
    }

    private void set(String iqId, IMClientSession session) throws Exception {
        IMRosterItem roster = new IMRosterItem();
        super.process((IMSession)session, roster);
        if ("remove".equals(roster.getSubscription())) {
            String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
            rosterAck = rosterAck + roster.toString();
            rosterAck = rosterAck + "</query></iq>";
            rosterAck = rosterAck + "<iq type='result' id='" + iqId + "'/>";
            this.emitToAllRegisteredSession(session, rosterAck);
            IMPresenceImpl presence = new IMPresenceImpl();
            presence.setTo(roster.getJID());
            presence.setFrom(session.getUser().getJID());
            presence.setType("unsubscribe");
            this.m_subscriptionManager.process((IMSession)session, (IMPresence)presence);
            presence = new IMPresenceImpl();
            presence.setTo(roster.getJID());
            presence.setFrom(session.getUser().getJID());
            presence.setType("unsubscribed");
            this.m_subscriptionManager.process((IMSession)session, (IMPresence)presence);
        } else {
            IMRosterItem localroster;
            this.getLogger().debug("Setting roster item " + roster);
            ArrayList<IMRosterItem> rosterList = session.getUser().getRosterItemList();
            this.getLogger().debug("RosterList for user " + session.getUser().getName() + " => " + rosterList);
            if (rosterList == null) {
                rosterList = new ArrayList<IMRosterItem>();
            }
            if ((localroster = this.getItemFromRosterList(roster.getJID(), rosterList)) == null) {
                roster.setSubscription("none");
            } else {
                localroster.setName(roster.getName());
                localroster.setGroup(roster.getGroup());
                roster = localroster;
            }
            if (roster.getName() == null || roster.getName().length() == 0) {
                roster.setName(roster.getJID());
            }
            if (roster.getGroup() == null || roster.getGroup().length() == 0) {
                roster.setGroup("General");
            }
            this.getLogger().debug("Got roster: " + roster);
            String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
            rosterAck = rosterAck + roster.toString();
            rosterAck = rosterAck + "</query></iq>";
            rosterAck = rosterAck + "<iq type='result' id='" + iqId + "'/>";
            String subscription = roster.getSubscription();
            if ("from".equals(subscription) || "none".equals(subscription) || subscription == null) {
                this.emitToAllRegisteredSession(session, rosterAck);
            }
            this.removeFromRosterList(rosterList, roster.getJID());
            rosterList.add(roster);
            this.getLogger().debug("Push rosterList for user " + session.getUser().getName() + " => " + rosterList);
            session.getUser().setRosterItemList(rosterList);
        }
    }

    private void get(String iqId, IMClientSession session) throws Exception {
        IMRosterItem rosterItem;
        int i;
        int l;
        String s = "<iq type='result' id='" + iqId + "' from='" + session.getUser().getJIDAndRessource() + "'>" + "<query xmlns='jabber:iq:roster'>";
        List rosterList = session.getUser().getRosterItemList();
        if (rosterList != null) {
            l = rosterList.size();
            for (i = 0; i < l; ++i) {
                rosterItem = (IMRosterItem)rosterList.get(i);
                s = s + rosterItem.toString();
            }
        }
        s = s + "</query></iq>";
        session.writeOutputStream(s);
        if (rosterList != null) {
            l = rosterList.size();
            for (i = 0; i < l; ++i) {
                rosterItem = (IMRosterItem)rosterList.get(i);
                String subscription = rosterItem.getSubscription();
                if (!"both".equals(subscription) && !"to".equals(subscription)) continue;
                Collection col = this.m_presenceHolder.getPresence(rosterItem.getJID());
                if (col != null && !col.isEmpty()) {
                    Iterator iter = col.iterator();
                    while (iter.hasNext()) {
                        IMPresence currentPresence = (IMPresence)iter.next();
                        session.writeOutputStream(currentPresence.toString());
                    }
                    continue;
                }
                IMPresenceImpl presence = new IMPresenceImpl();
                presence.setFrom(session.getUser().getJID());
                presence.setTo(rosterItem.getJID());
                presence.setType("probe");
                session.getRouter().route((IMSession)session, (Transitable)presence);
            }
        }
    }

    private final void removeFromRosterList(List rosterList, String jid) {
        this.getLogger().debug("Removing roster item " + jid);
        int l = rosterList.size();
        for (int i = 0; i < l; ++i) {
            IMRosterItem rosterItem = (IMRosterItem)rosterList.get(i);
            if (!rosterItem.getJID().equals(jid)) continue;
            rosterList.remove(i);
            break;
        }
    }

    private final IMRosterItem getItemFromRosterList(String jid, List rosterList) {
        IMRosterItem rosterItem = null;
        int l = rosterList.size();
        for (int i = 0; i < l && !(rosterItem = (IMRosterItem)rosterList.get(i)).getJID().equals(jid); ++i) {
            rosterItem = null;
        }
        return rosterItem;
    }

    private final void emitToAllRegisteredSession(IMClientSession session, String str) throws Exception {
        List sessionList = session.getRouter().getAllRegisteredSession(session.getUser().getName());
        int l = sessionList.size();
        for (int i = 0; i < l; ++i) {
            IMSession s = (IMSession)sessionList.get(i);
            s.writeOutputStream(str);
        }
    }
}

