/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.register;

import java.util.HashMap;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.UsersManager;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.jabber.User;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.jabber.iq.register.Query;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class QueryImpl
extends DefaultSessionProcessor
implements Query {
    private ServerParameters m_serverParameters;
    private UsersManager m_usersManager;
    private AccountRepositoryHolder m_accountRepository;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_usersManager = (UsersManager)serviceManager.lookup("UsersManager");
        this.m_accountRepository = (AccountRepositoryHolder)serviceManager.lookup("AccountRepositoryHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        super.service(serviceManager);
    }

    public void process(IMSession session, Object context) throws Exception {
        IMClientSession clientSession = (IMClientSession)session;
        User currentUser = clientSession.getUser();
        User user = this.m_usersManager.getNewUser();
        clientSession.setUser(user);
        HashMap<Integer, Boolean> contextMap = new HashMap<Integer, Boolean>();
        contextMap.put(Query.CTX_SHOULD_REMOVE, Boolean.FALSE);
        super.process(session, contextMap);
        String iqId = ((IMIq)context).getId();
        String type = ((IMIq)context).getType();
        if ("get".equals(type)) {
            String s = "<iq type='result' id='" + iqId + "' from='" + this.m_serverParameters.getHostName() + "'>" + "<query xmlns='jabber:iq:register'>" + "<instructions>Choose a username and password to register with this service.</instructions>" + "<password/><username/>" + "</query></iq>";
            session.writeOutputStream(s);
        } else if ("set".equals(type)) {
            Boolean shouldRemove = (Boolean)contextMap.get(Query.CTX_SHOULD_REMOVE);
            if (shouldRemove.booleanValue()) {
                this.m_accountRepository.removeAccount(currentUser.getName());
                String s = "<iq type='result' id='" + iqId + "' />";
                session.writeOutputStream(s);
                clientSession.setUser(null);
            } else {
                Account existingAccount = this.m_accountRepository.getAccount(user.getName());
                if (existingAccount == null) {
                    this.setAccount(user);
                    IMRouter router = session.getRouter();
                    router.registerSession(clientSession);
                    String s = "<iq type='result' id='" + iqId + "' />";
                    session.writeOutputStream(s);
                } else if (currentUser != null) {
                    String s = null;
                    if (currentUser.getName().equals(user.getName())) {
                        this.setAccount(user);
                        s = "<iq type='result' id='" + iqId + "' />";
                    } else {
                        clientSession.setUser(currentUser);
                        s = "<iq type='error' id='" + iqId + "' />";
                    }
                    session.writeOutputStream(s);
                } else {
                    String s = "<iq type='error' id='" + iqId + "' />";
                    session.writeOutputStream(s);
                }
            }
        }
    }

    private void setAccount(User user) throws Exception {
        Account account = (Account)this.m_serviceManager.lookup("Account");
        account.setName(user.getName());
        account.setPassword(user.getPassword());
        this.m_accountRepository.setAccount(account);
    }
}

