/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.jprivate;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.storage.PrivateRepositoryHolder;
import net.java.dev.openim.jabber.iq.jprivate.Query;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class QueryImpl
extends DefaultSessionProcessor
implements Query {
    private PrivateRepositoryHolder m_privateRepository;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_privateRepository = (PrivateRepositoryHolder)serviceManager.lookup("PrivateRepositoryHolder");
    }

    public void process(IMSession session, Object context) throws Exception {
        IMClientSession clientSession = (IMClientSession)session;
        String type = ((IMIq)context).getType();
        if ("get".equals(type)) {
            this.get(clientSession, context);
        } else if ("set".equals(type)) {
            this.set(clientSession, context);
        }
    }

    private void get(IMClientSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String iqId = ((IMIq)context).getId();
        int eventType = xpp.next();
        String privateKey = xpp.getNamespace() + ':' + xpp.getName();
        String data = this.m_privateRepository.getData(session.getUser().getName(), privateKey);
        if (data == null) {
            data = "<" + xpp.getName() + " xmlns='" + xpp.getNamespace() + "'/>";
        }
        this.getLogger().debug("Got data (" + privateKey + "): " + data);
        String s = "<iq type='result'";
        s = s + " from='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " to='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " id='" + iqId + "'>";
        s = s + "<query xmlns='jabber:iq:private'>";
        s = s + data;
        s = s + "</query>";
        s = s + "</iq>";
        session.writeOutputStream(s);
        this.skip(xpp);
    }

    private void set(IMClientSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String privateKey = xpp.getNamespace() + ':' + xpp.getName();
        String data = this.serialize(xpp).toString();
        this.getLogger().debug("Got private key " + privateKey + " => data: " + data);
        if (data != null && data.length() > 0) {
            this.m_privateRepository.setData(session.getUser().getName(), privateKey, data);
        }
        String iqId = ((IMIq)context).getId();
        String s = "<iq type='result'";
        s = s + " from='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " to='" + session.getUser().getJIDAndRessource() + "'";
        s = s + " id='" + iqId + "'/>";
    }
}

