/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.iq.auth;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.UsersManager;
import net.java.dev.openim.data.jabber.IMIq;
import net.java.dev.openim.data.jabber.User;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.jabber.iq.auth.Query;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class QueryImpl
extends DefaultSessionProcessor
implements Query {
    private ServerParameters m_serverParameters;
    private UsersManager m_usersManager;
    private AccountRepositoryHolder m_accountHolder;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_usersManager = (UsersManager)serviceManager.lookup("UsersManager");
        this.m_accountHolder = (AccountRepositoryHolder)serviceManager.lookup("AccountRepositoryHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        super.service(serviceManager);
    }

    public void process(IMSession session, Object context) throws Exception {
        IMClientSession clientSession = (IMClientSession)session;
        String iqId = ((IMIq)context).getId();
        String type = ((IMIq)context).getType();
        User user = this.m_usersManager.getNewUser();
        clientSession.setUser(user);
        user.setHostname(this.m_serverParameters.getHostName());
        if ("get".equals(type)) {
            super.process(session, context);
            String s = null;
            Account account = this.m_accountHolder.getAccount(user.getName());
            if (account == null) {
                s = "<iq type='error' id='" + iqId + "'>" + "<query xmlns='jabber:iq:auth'><username>" + user.getName() + "</username></query>" + "<error code='401'>Unauthorized</error>" + "</iq>";
            } else {
                s = "<iq type='result' id='" + iqId + "' from='" + this.m_serverParameters.getHostName() + "'>" + "<query xmlns='jabber:iq:auth'>" + "<username>" + user.getName() + "</username>";
                if (user.isAuthenticationTypeSupported(1)) {
                    s = s + "<password/>";
                }
                if (user.isAuthenticationTypeSupported(2)) {
                    s = s + "<digest/>";
                }
                s = s + "<resource/></query></iq>";
            }
            session.writeOutputStream(s);
        } else if ("set".equals(type)) {
            super.process(session, context);
            try {
                user.authenticate(Long.toString(session.getId()));
                IMRouter router = session.getRouter();
                router.registerSession(clientSession);
                String s = "<iq type='result' id='" + iqId + "' />";
                session.writeOutputStream(s);
            }
            catch (Exception e) {
                this.getLogger().debug(e.getMessage(), (Throwable)e);
                String s = "<iq type='error' id='" + iqId + "' />";
                session.writeOutputStream(s);
            }
        }
    }
}

