/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber.client;

import java.util.List;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMPresenceHolder;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.SubscriptionManager;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.IMPresence;
import net.java.dev.openim.data.jabber.IMPresenceImpl;
import net.java.dev.openim.data.jabber.IMRosterItem;
import net.java.dev.openim.jabber.client.Presence;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class PresenceImpl
extends DefaultSessionProcessor
implements Presence {
    private IMPresenceHolder m_presenceHolder;
    private SubscriptionManager m_subscriptionManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this.m_presenceHolder = (IMPresenceHolder)serviceManager.lookup("IMPresenceHolder");
        this.m_subscriptionManager = (SubscriptionManager)serviceManager.lookup("SubscriptionManager");
    }

    public void process(IMSession session, Object context) throws Exception {
        IMClientSession clientSession = (IMClientSession)session;
        XmlPullParser xpp = session.getXmlPullParser();
        String type = xpp.getAttributeValue("", "type");
        String to = xpp.getAttributeValue("", "to");
        String from = xpp.getAttributeValue("", "from");
        if (from == null || from.length() == 0) {
            from = clientSession.getUser().getJIDAndRessource();
        }
        IMPresenceImpl presence = new IMPresenceImpl();
        presence.setType(type);
        presence.setFrom(from);
        super.process(session, presence);
        clientSession.setPresence((IMPresence)presence);
        if (type == null || type.length() == 0 || "available".equals(type) || "unavailable".equals(type)) {
            this.m_presenceHolder.setPresence(from, (IMPresence)presence);
        }
        this.getLogger().debug("Got presence (to " + to + ") " + presence);
        IMRouter router = session.getRouter();
        if (to == null || to.length() == 0 || to.equals("null")) {
            List rosterList = clientSession.getUser().getRosterItemList();
            if (rosterList != null) {
                int l = rosterList.size();
                for (int i = 0; i < l; ++i) {
                    IMRosterItem item = (IMRosterItem)rosterList.get(i);
                    IMPresence localPresence = (IMPresence)presence.clone();
                    localPresence.setTo(item.getJID());
                    router.route(session, (Transitable)localPresence);
                }
            }
        } else {
            IMPresence localPresence = (IMPresence)presence.clone();
            localPresence.setTo(to);
            this.m_subscriptionManager.process(session, localPresence);
        }
    }
}

