/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.jabber;

import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.jabber.Streams;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class StreamsImpl
extends DefaultSessionProcessor
implements Streams {
    private ServerParameters m_serverParameters;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        super.service(serviceManager);
    }

    public void process(IMSession session, Object context) throws Exception {
        this.processAttribute(session, context);
        if (session instanceof IMServerSession) {
            this.getLogger().info("Start stream " + ((IMServerSession)session).getRemoteHostname() + " id " + session.getId());
        }
        super.process(session, context);
        if (session instanceof IMServerSession) {
            this.getLogger().info("Stop stream " + ((IMServerSession)session).getRemoteHostname() + " id " + session.getId());
        }
    }

    public void processAttribute(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String to = xpp.getAttributeValue("", "to");
        String from = xpp.getAttributeValue("", "from");
        if (from == null || from.length() == 0) {
            this.getLogger().debug("from attribut not specified in stream declaration");
        } else if (session instanceof IMServerSession) {
            ((IMServerSession)session).setRemoteHostname(from);
        }
        if (session.getConnectionType() == 2) {
            this.getLogger().debug("Local to Remote connection " + to);
        } else {
            String s = "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' id='" + session.getId() + "' ";
            if (session.getConnectionType() == 1) {
                s = s + "xmlns='jabber:client' ";
            } else if (session.getConnectionType() == 3) {
                s = s + "xmlns='jabber:server' xmlns:db='jabber:server:dialback' ";
            }
            s = s + "from='" + this.m_serverParameters.getHostName() + "'>";
            session.writeOutputStream(s);
        }
    }
}

