/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim.data.jabber;

import java.util.List;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.jabber.User;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.data.storage.RosterListRepositoryHolder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserImpl
extends AbstractLogEnabled
implements User,
Serviceable {
    private String m_name;
    private String m_hostname;
    private String m_password;
    private String m_digest;
    private String m_resource;
    private ServiceManager m_serviceManager;
    private AccountRepositoryHolder m_accountHolder;
    private RosterListRepositoryHolder m_rosterListHolder;
    private ServerParameters m_serverParameters;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        this.m_accountHolder = (AccountRepositoryHolder)serviceManager.lookup("AccountRepositoryHolder");
        this.m_rosterListHolder = (RosterListRepositoryHolder)serviceManager.lookup("RosterListRepositoryHolder");
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final String getHostname() {
        return this.m_hostname;
    }

    public final void setHostname(String hostname) {
        this.m_hostname = hostname;
    }

    public final void setPassword(String password) {
        this.m_password = password;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final String getResource() {
        return this.m_resource;
    }

    public final String getDigest() {
        return this.m_digest;
    }

    public final void setDigest(String digest) {
        this.m_digest = digest;
    }

    public final void setResource(String resource) {
        this.m_resource = resource;
    }

    public boolean isAuthenticationTypeSupported(int type) {
        Account account = this.m_accountHolder.getAccount(this.m_name);
        boolean b = false;
        if (account == null) {
            this.getLogger().warn("Account " + this.m_name + " does not exist");
        } else {
            b = account.isAuthenticationTypeSupported(type);
        }
        return b;
    }

    public void authenticate(String sessionId) throws Exception {
        this.getLogger().info("Authenticating " + this.getJID() + " digest " + this.m_digest);
        Account account = this.m_accountHolder.getAccount(this.m_name);
        if (account == null) {
            throw new Exception("Unknow JID " + this.getJIDAndRessource());
        }
        if (this.m_password == null) {
            account.authenticate(2, this.m_digest, sessionId);
        } else {
            account.authenticate(1, this.m_password, sessionId);
        }
    }

    public final String getJID() {
        String s = this.m_name;
        if (this.m_hostname != null) {
            s = s + "@" + this.m_hostname;
        }
        return s;
    }

    public final String getNameAndRessource() {
        return this.m_name + "/" + this.m_resource;
    }

    public final String getJIDAndRessource() {
        return this.getJID() + "/" + this.m_resource;
    }

    public List getRosterItemList() {
        List rosterList = this.m_rosterListHolder.getRosterList(this.m_name);
        return rosterList;
    }

    public void setRosterItemList(List rosterlist) {
        this.m_rosterListHolder.setRosterList(this.m_name, rosterlist);
    }

    public String toString() {
        return this.getJIDAndRessource();
    }

    public User newInstance() {
        UserImpl user = new UserImpl();
        user.enableLogging(this.getLogger());
        try {
            user.service(this.m_serviceManager);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return user;
    }
}

