/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.java.dev.openim.IMPresenceHolder;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.SubscriptionManager;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.DeferrableIMPresenceImpl;
import net.java.dev.openim.data.jabber.IMPresence;
import net.java.dev.openim.data.jabber.IMPresenceImpl;
import net.java.dev.openim.data.jabber.IMRosterItem;
import net.java.dev.openim.data.storage.RosterListRepositoryHolder;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.tools.JIDParser;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SubscriptionManagerImpl
extends AbstractLogEnabled
implements SubscriptionManager,
Serviceable {
    private IMPresenceHolder m_presenceHolder;
    private RosterListRepositoryHolder m_rosterListReposityHolder;
    private ServerParameters m_serverParameters;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_rosterListReposityHolder = (RosterListRepositoryHolder)serviceManager.lookup("RosterListRepositoryHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        this.m_presenceHolder = (IMPresenceHolder)serviceManager.lookup("IMPresenceHolder");
    }

    public void process(IMSession session, IMPresence presence) throws Exception {
        String type;
        presence = new DeferrableIMPresenceImpl(presence);
        String to = JIDParser.getJID(presence.getTo());
        String from = JIDParser.getJID(presence.getFrom());
        presence.setTo(to);
        presence.setFrom(from);
        boolean toLocalHost = false;
        if (this.m_serverParameters.getHostNameList().contains(JIDParser.getHostname(to))) {
            toLocalHost = true;
        }
        boolean fromLocalHost = false;
        if (this.m_serverParameters.getHostNameList().contains(JIDParser.getHostname(from))) {
            fromLocalHost = true;
        }
        if ("subscribe".equals(type = presence.getType())) {
            if (fromLocalHost) {
                this.preSubscribe(session, presence, toLocalHost);
            } else {
                this.postSubscribe(session, presence);
            }
        } else if ("subscribed".equals(type)) {
            if (fromLocalHost) {
                this.preSubscribed(session, presence, toLocalHost);
            } else {
                this.postSubscribed(session, presence);
            }
        } else if ("unsubscribe".equals(type)) {
            if (fromLocalHost) {
                this.preUnsubscribe(session, presence, toLocalHost);
            } else {
                this.postUnsubscribe(session, presence);
            }
        } else if ("unsubscribed".equals(type)) {
            if (fromLocalHost) {
                this.preUnsubscribed(session, presence, toLocalHost);
            } else {
                this.postUnsubscribed(session, presence);
            }
        } else {
            session.getRouter().route(session, (Transitable)presence);
        }
    }

    private void preSubscribe(IMSession session, IMPresence presence, boolean toLocalHost) throws Exception {
        String to = presence.getTo();
        String from = presence.getFrom();
        IMRosterItem roster = this.getRoster(from, to);
        roster.setAsk("subscribe");
        String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
        if (roster != null) {
            rosterAck = rosterAck + roster.toString();
        }
        rosterAck = rosterAck + "</query></iq>";
        roster.setAsk(null);
        this.emitToAllRegisteredSession(session, from, rosterAck);
        if (toLocalHost) {
            this.postSubscribe(session, presence);
        } else {
            session.getRouter().route(session, (Transitable)presence);
        }
    }

    private void postSubscribe(IMSession session, IMPresence presence) throws Exception {
        String subscription;
        String from;
        String to = presence.getTo();
        IMRosterItem roster = this.getRoster(to, from = presence.getFrom());
        if (roster == null) {
            roster = new IMRosterItem();
            roster.setSubscription("none");
            roster.setJID(from);
            roster.setName(from);
            roster.setGroup("General");
            this.addRoster(to, roster);
        }
        if ("to".equals(subscription = roster.getSubscription()) || "none".equals(subscription) || subscription == null) {
            if ("from".equals(subscription)) {
                this.setRosterSubcription(to, from, "both");
            } else {
                this.setRosterSubcription(to, from, "to");
            }
            if ("to".equals(subscription)) {
                this.setRosterSubcription(to, from, "both");
            } else {
                this.setRosterSubcription(to, from, "from");
            }
            session.getRouter().route(session, (Transitable)presence);
        }
    }

    private void preSubscribed(IMSession session, IMPresence presence, boolean toLocalHost) throws Exception {
        String to = presence.getTo();
        String from = presence.getFrom();
        IMRosterItem roster = this.getRoster(from, to);
        String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
        if (roster != null) {
            rosterAck = rosterAck + roster.toString();
        }
        rosterAck = rosterAck + "</query></iq>";
        this.emitToAllRegisteredSession(session, from, rosterAck);
        if (toLocalHost) {
            this.postSubscribed(session, presence);
        } else {
            session.getRouter().route(session, (Transitable)presence);
        }
        Collection col = this.m_presenceHolder.getPresence(from);
        if (col != null && !col.isEmpty()) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                IMPresence currentPresence = (IMPresence)iter.next();
                currentPresence = (IMPresence)currentPresence.clone();
                currentPresence.setTo(to);
                session.getRouter().route(session, (Transitable)currentPresence);
            }
        }
    }

    private void postSubscribed(IMSession session, IMPresence presence) throws Exception {
        String subscription;
        String from;
        String to = presence.getTo();
        IMRosterItem roster = this.getRoster(to, from = presence.getFrom());
        if (roster == null) {
            roster = new IMRosterItem();
            roster.setSubscription("none");
            roster.setJID(from);
            roster.setName(from);
            roster.setGroup("General");
            this.addRoster(to, roster);
        }
        if ("from".equals(subscription = roster.getSubscription()) || "none".equals(subscription) || subscription == null) {
            session.getRouter().route(session, (Transitable)presence);
            if ("from".equals(subscription)) {
                this.setRosterSubcription(to, from, "both");
                roster.setSubscription("both");
            } else {
                this.setRosterSubcription(to, from, "to");
                roster.setSubscription("to");
            }
            String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
            rosterAck = rosterAck + roster.toString();
            rosterAck = rosterAck + "</query></iq>";
            this.emitToAllRegisteredSession(session, to, rosterAck);
        }
    }

    private void preUnsubscribe(IMSession session, IMPresence presence, boolean toLocalHost) throws Exception {
        String to = presence.getTo();
        String from = presence.getFrom();
        IMRosterItem roster = this.getRoster(from, to);
        if (roster != null) {
            roster.setSubscription("none");
            String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
            rosterAck = rosterAck + roster.toString();
            rosterAck = rosterAck + "</query></iq>";
            this.emitToAllRegisteredSession(session, from, rosterAck);
            this.removeRoster(from, to);
        }
        if (toLocalHost) {
            this.postUnsubscribe(session, presence);
        } else {
            session.getRouter().route(session, (Transitable)presence);
        }
    }

    private void postUnsubscribe(IMSession session, IMPresence presence) throws Exception {
        session.getRouter().route(session, (Transitable)presence);
    }

    private void preUnsubscribed(IMSession session, IMPresence presence, boolean toLocalHost) throws Exception {
        String to = presence.getTo();
        String from = presence.getFrom();
        if (toLocalHost) {
            this.postUnsubscribed(session, presence);
        } else {
            session.getRouter().route(session, (Transitable)presence);
        }
        IMPresenceImpl currentPresence = new IMPresenceImpl();
        currentPresence.setFrom(from);
        currentPresence.setTo(to);
        currentPresence.setType("unavailable");
    }

    private void postUnsubscribed(IMSession session, IMPresence presence) throws Exception {
        String from;
        String to = presence.getTo();
        IMRosterItem roster = this.getRoster(to, from = presence.getFrom());
        if (roster != null) {
            roster.setSubscription("none");
            String rosterAck = "<iq type='set'><query xmlns='jabber:iq:roster'>";
            rosterAck = rosterAck + roster.toString();
            rosterAck = rosterAck + "</query></iq>";
            this.emitToAllRegisteredSession(session, to, rosterAck);
            this.removeRoster(to, from);
        }
        session.getRouter().route(session, (Transitable)presence);
    }

    private final void addRoster(String usernameJID, IMRosterItem roster) {
        String username = JIDParser.getName(usernameJID);
        ArrayList<IMRosterItem> rosterList = this.m_rosterListReposityHolder.getRosterList(username);
        if (rosterList == null) {
            rosterList = new ArrayList<IMRosterItem>();
        }
        rosterList.add(roster);
        this.m_rosterListReposityHolder.setRosterList(username, rosterList);
    }

    private final void setRosterSubcription(String usernameJID, String itemJID, String subscription) {
        IMRosterItem roster;
        String username = JIDParser.getName(usernameJID);
        ArrayList rosterList = this.m_rosterListReposityHolder.getRosterList(username);
        if (rosterList == null) {
            rosterList = new ArrayList();
        }
        if ((roster = this.getItemFromRosterList(itemJID, rosterList)) != null) {
            roster.setSubscription(subscription);
        }
        this.m_rosterListReposityHolder.setRosterList(username, rosterList);
    }

    private final void removeRoster(String usernameJID, String itemJID) {
        String username = JIDParser.getName(usernameJID);
        ArrayList rosterList = this.m_rosterListReposityHolder.getRosterList(username);
        if (rosterList == null) {
            rosterList = new ArrayList();
        }
        this.removeFromRosterList(rosterList, itemJID);
        this.m_rosterListReposityHolder.setRosterList(username, rosterList);
    }

    private final IMRosterItem getRoster(String usernameJID, String itemJID) {
        String username = JIDParser.getName(usernameJID);
        ArrayList rosterList = this.m_rosterListReposityHolder.getRosterList(username);
        if (rosterList == null) {
            rosterList = new ArrayList();
        }
        return this.getItemFromRosterList(itemJID, rosterList);
    }

    private final void removeFromRosterList(List rosterList, String jid) {
        this.getLogger().debug("Removing roster item " + jid);
        int l = rosterList.size();
        for (int i = 0; i < l; ++i) {
            IMRosterItem rosterItem = (IMRosterItem)rosterList.get(i);
            if (!rosterItem.getJID().equals(jid)) continue;
            rosterList.remove(i);
            break;
        }
    }

    private final IMRosterItem getItemFromRosterList(String jid, List rosterList) {
        IMRosterItem rosterItem = null;
        int l = rosterList.size();
        for (int i = 0; i < l && !(rosterItem = (IMRosterItem)rosterList.get(i)).getJID().equals(jid); ++i) {
            rosterItem = null;
        }
        return rosterItem;
    }

    private final void emitToAllRegisteredSession(IMSession session, String usernameJID, String str) throws Exception {
        String username = JIDParser.getName(usernameJID);
        List sessionList = session.getRouter().getAllRegisteredSession(username);
        int l = sessionList.size();
        for (int i = 0; i < l; ++i) {
            IMSession s = (IMSession)sessionList.get(i);
            s.writeOutputStream(str);
        }
    }
}

