/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.io.IOException;
import net.java.dev.openim.IMConnectionHandler;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.SimpleMessageRouter;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.IMMessage;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SimpleMessageRouterImpl
extends AbstractLogEnabled
implements SimpleMessageRouter,
Serviceable {
    private ServiceManager m_serviceManager;
    private SessionsManager m_sessionsManager;
    private IMRouter m_router;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        this.m_router = (IMRouter)serviceManager.lookup("IMRouter");
        IMConnectionHandler connectionHandler = (IMConnectionHandler)serviceManager.lookup("IMConnectionHandler");
    }

    public void route(String from, String to, String type, String subject, String body, String threadId) throws IOException {
        IMMessage message = new IMMessage();
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(body);
        message.setThread(threadId);
        message.setType(type);
        IMClientSession session = null;
        try {
            session = this.m_sessionsManager.getNewClientSession();
            session.setRouter(this.m_router);
            this.m_router.route((IMSession)session, (Transitable)message);
        }
        catch (Exception e) {
            this.getLogger().warn(e.getMessage(), (Throwable)e);
        }
    }
}

