/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.openim.ServerParameters;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class ServerParametersImpl
extends AbstractLogEnabled
implements ServerParameters,
Configurable {
    private List m_hostnameList;
    private int m_localClientPort;
    private int m_localSSLClientPort;
    private int m_localServerPort;
    private int m_localSSLServerPort;
    private int m_remoteServerPort;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_localClientPort = configuration.getChild("local-client-port").getValueAsInteger(5222);
        this.m_localSSLClientPort = configuration.getChild("local-ssl-client-port").getValueAsInteger(5223);
        this.m_localServerPort = configuration.getChild("local-server-port").getValueAsInteger(5269);
        this.m_localSSLServerPort = configuration.getChild("local-ssl-server-port").getValueAsInteger(5270);
        this.m_remoteServerPort = configuration.getChild("remote-server-port").getValueAsInteger(5269);
        Configuration[] confs = configuration.getChildren("hostname");
        this.m_hostnameList = new ArrayList(confs.length);
        int l = confs.length;
        for (int i = 0; i < l; ++i) {
            this.m_hostnameList.add(confs[i].getValue());
        }
        if (this.m_hostnameList.size() == 0) {
            try {
                this.m_hostnameList.add(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger().info("Host list set to: " + this.m_hostnameList);
    }

    public final int getLocalClientPort() {
        return this.m_localClientPort;
    }

    public final int getLocalSSLClientPort() {
        return this.m_localSSLClientPort;
    }

    public final int getLocalServerPort() {
        return this.m_localServerPort;
    }

    public final int getLocalSSLServerPort() {
        return this.m_localSSLServerPort;
    }

    public final List getHostNameList() {
        return this.m_hostnameList;
    }

    public final String getHostName() {
        return (String)this.m_hostnameList.get(0);
    }

    public final int getRemoteServerPort() {
        return this.m_remoteServerPort;
    }
}

