/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.util.HashMap;
import java.util.Map;
import net.java.dev.openim.IMConnectionHandler;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.S2SConnector;
import net.java.dev.openim.S2SConnectorManager;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class S2SConnectorManagerImpl
extends AbstractLogEnabled
implements S2SConnectorManager,
Initializable,
Serviceable {
    private Map m_hostnameAndS2SMap;
    private ServiceManager m_serviceManager;
    private IMConnectionHandler m_connectionHandler;
    private IMRouter m_router;
    private SessionsManager m_sessionsManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        this.m_router = (IMRouter)serviceManager.lookup("IMRouter");
    }

    public void initialize() throws Exception {
        this.m_hostnameAndS2SMap = new HashMap();
    }

    public void setConnectionHandler(IMConnectionHandler connectionHandler) {
        this.m_connectionHandler = connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMServerSession getCurrentRemoteSession(String hostname) throws Exception {
        IMServerSession session = null;
        Map map = this.m_hostnameAndS2SMap;
        synchronized (map) {
            S2SConnector s2s = (S2SConnector)this.m_hostnameAndS2SMap.get(hostname);
            if (s2s != null && !s2s.getSession().isClosed()) {
                session = s2s.getSession();
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMServerSession getRemoteSessionWaitForValidation(String hostname, long timeout) throws Exception {
        IMServerSession session = null;
        S2SConnector s2s = null;
        Map map = this.m_hostnameAndS2SMap;
        synchronized (map) {
            s2s = (S2SConnector)this.m_hostnameAndS2SMap.get(hostname);
            if (s2s != null && !s2s.getSession().isClosed()) {
                session = s2s.getSession();
            } else {
                s2s = this.getS2SConnector(hostname);
                session = s2s.getSession();
            }
        }
        map = session;
        synchronized (map) {
            if (!session.getDialbackValid()) {
                s2s.sendResult();
                this.getLogger().info("Wait validation for " + hostname + " for session " + session);
                session.wait(timeout);
            }
        }
        if (!session.getDialbackValid()) {
            throw new Exception("Unable to get dialback validation for " + hostname + " after timeout " + timeout + " ms");
        }
        this.getLogger().info("Validation granted from " + hostname + " for session " + session);
        return session;
    }

    public void verifyRemoteHost(String hostname, String dialbackValue, String id, IMServerSession session) throws Exception {
        S2SConnector s2s = this.getS2SConnector(hostname);
        s2s.sendVerify(dialbackValue, id);
        if (!s2s.getSession().getDialbackValid()) {
            s2s.sendResult();
        }
        session.setTwinSession(s2s.getSession());
        s2s.getSession().setTwinSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S2SConnector getS2SConnector(String hostname) throws Exception {
        S2SConnector s2s = null;
        Map map = this.m_hostnameAndS2SMap;
        synchronized (map) {
            s2s = (S2SConnector)this.m_hostnameAndS2SMap.get(hostname);
            if (s2s != null && !s2s.isAlive()) {
                this.getLogger().info("Removing s2s for hostname (thread not alive) " + hostname);
                this.m_hostnameAndS2SMap.remove(hostname);
                s2s = null;
            }
            if (s2s == null || s2s.getSession().isClosed()) {
                s2s = (S2SConnector)this.m_serviceManager.lookup("S2SConnector");
                s2s.setIMConnectionHandler(this.m_connectionHandler);
                s2s.setRouter(this.m_router);
                s2s.setSessionsManager(this.m_sessionsManager);
                s2s.setToHostname(hostname);
                new Thread((Runnable)s2s).start();
                this.m_hostnameAndS2SMap.put(hostname, s2s);
            }
        }
        return s2s;
    }
}

