/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.java.dev.openim.IMConnectionHandler;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.S2SConnector;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.xmlpull.v1.XmlPullParser;

public class S2SConnectorImpl
extends AbstractLogEnabled
implements S2SConnector,
Runnable,
Configurable,
Serviceable {
    private ServerParameters m_serverParameters;
    private SessionsManager m_sessionsManager;
    private IMConnectionHandler m_connectionHandler;
    private int m_deliveryConnectionTimout;
    private String m_toHostName;
    private IMServerSession m_session;
    private IMRouter m_router;
    private volatile boolean m_isAlive = false;
    private volatile boolean m_ready = false;
    private volatile boolean m_sendResult = false;
    private volatile boolean m_sendVerify = false;
    private volatile String m_verifyDialbackValue;
    private volatile String m_verifyId;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_deliveryConnectionTimout = configuration.getChild("delivery-connection-timeout").getValueAsInteger(60000);
    }

    public void setToHostname(String toHostname) {
        this.m_toHostName = toHostname;
    }

    public void setRouter(IMRouter router) {
        this.m_router = router;
    }

    public void setIMConnectionHandler(IMConnectionHandler connectionHandler) {
        this.m_connectionHandler = connectionHandler;
    }

    public void setSessionsManager(SessionsManager sessionManager) {
        this.m_sessionsManager = sessionManager;
    }

    public IMServerSession getSession() throws Exception {
        if (this.m_session == null) {
            this.m_session = this.m_sessionsManager.getNewServerSession();
            this.m_session.setRouter(this.m_router);
            this.m_session.setRemoteHostname(this.m_toHostName);
        }
        return this.m_session;
    }

    public boolean isAlive() {
        return this.m_isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_isAlive = true;
        try {
            try {
                Socket socket = new Socket();
                InetSocketAddress insa = new InetSocketAddress(this.m_toHostName, this.m_serverParameters.getRemoteServerPort());
                this.getLogger().debug("Trying to connect (timeout " + this.m_deliveryConnectionTimout + " ms) to " + this.m_toHostName + ":" + this.m_serverParameters.getRemoteServerPort());
                socket.connect(insa, this.m_deliveryConnectionTimout);
                this.getLogger().info("Connection to " + this.m_toHostName + ":" + this.m_serverParameters.getRemoteServerPort() + " successfull");
                IMServerSession session = this.getSession();
                session.setup(socket);
                XmlPullParser xpp = session.getXmlPullParser();
                int eventType = xpp.getEventType();
                while (eventType != 0) {
                    eventType = xpp.getEventType();
                }
                String s = "<?xml version='1.0' encoding='" + session.getEncoding() + "' ?>";
                s = s + "<stream:stream xmlns:stream='http://etherx.jabber.org/streams' xmlns='jabber:server' to='" + this.m_toHostName + "' " + "from='" + this.m_serverParameters.getHostName() + "' " + "id='" + session.getId() + "' " + "xmlns:db='jabber:server:dialback'>";
                session.writeOutputStream(s);
                this.m_ready = true;
                if (this.m_sendVerify) {
                    this.sendVerify(this.m_verifyDialbackValue, this.m_verifyId);
                }
                if (this.m_sendResult) {
                    this.sendResult();
                }
                this.m_connectionHandler.process((IMSession)session);
            }
            catch (Exception e) {
                this.getLogger().error("L2R " + this.m_toHostName + " session exception: " + e.getMessage(), (Throwable)e);
                Object var8_9 = null;
                this.m_isAlive = false;
                if (!this.m_session.isClosed()) {
                    this.getLogger().info("Release session " + this.m_session.getId());
                    this.m_sessionsManager.release((IMSession)this.m_session);
                }
                IMServerSession iMServerSession2 = this.m_session;
                synchronized (iMServerSession2) {
                    this.m_session.notifyAll();
                    return;
                }
            }
            Object var8_8 = null;
            this.m_isAlive = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_isAlive = false;
            if (!this.m_session.isClosed()) {
                this.getLogger().info("Release session " + this.m_session.getId());
                this.m_sessionsManager.release((IMSession)this.m_session);
            }
            IMServerSession iMServerSession = this.m_session;
            synchronized (iMServerSession) {
                this.m_session.notifyAll();
                throw throwable;
            }
        }
        if (!this.m_session.isClosed()) {
            this.getLogger().info("Release session " + this.m_session.getId());
            this.m_sessionsManager.release((IMSession)this.m_session);
        }
        IMServerSession iMServerSession = this.m_session;
        synchronized (iMServerSession) {
            this.m_session.notifyAll();
            return;
        }
    }

    public void sendResult() throws IOException {
        if (!this.m_ready) {
            this.m_sendResult = true;
        } else if (this.m_session.getDialbackValue() == null) {
            String dialbackValue = Long.toString(this.m_session.getId());
            this.m_session.setDialbackValue(dialbackValue);
            String s = "<db:result from='" + this.m_serverParameters.getHostName() + "' to='" + this.m_toHostName + "'>";
            s = s + dialbackValue;
            s = s + "</db:result>";
            this.getLogger().info("Started dialback validation for host " + this.m_toHostName + " id " + this.m_session.getId());
            this.m_session.writeOutputStream(s);
        }
    }

    public void sendVerify(String dialbackValue, String id) throws IOException {
        if (!this.m_ready) {
            this.m_sendVerify = true;
            this.m_verifyDialbackValue = dialbackValue;
            this.m_verifyId = id;
        } else {
            String s = "<db:verify from='" + this.m_serverParameters.getHostName() + "' to='" + this.m_toHostName + "' id='" + id + "'>";
            s = s + dialbackValue;
            s = s + "</db:verify>";
            this.m_session.writeOutputStream(s);
        }
    }
}

