/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import net.java.dev.openim.IMServer;
import net.java.dev.openim.ServerParameters;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.cornerstone.services.connection.ConnectionManager;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class IMServerImpl
extends AbstractLogEnabled
implements IMServer,
Configurable,
Initializable,
ConnectionHandlerFactory,
Serviceable {
    private ServerParameters m_serverParameters;
    private ServiceManager m_serviceManager;
    private SocketManager m_socketManager;
    private ConnectionManager m_connectionManager;
    private int m_listenBacklog;
    private InetAddress m_bindTo;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_listenBacklog = configuration.getChild("listen-backlog").getValueAsInteger();
        String bindAddress = configuration.getChild("bind").getValue(null);
        try {
            if (bindAddress != null) {
                this.m_bindTo = InetAddress.getByName(bindAddress);
            }
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Unable to bind " + bindAddress, (Throwable)e);
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_socketManager = (SocketManager)serviceManager.lookup("SocketManager");
        this.m_connectionManager = (ConnectionManager)serviceManager.lookup("ConnectionManager");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
    }

    public void initialize() throws Exception {
        ServerSocketFactory factory = this.m_socketManager.getServerSocketFactory("plain");
        ServerSocket clientServerSocket = factory.createServerSocket(this.m_serverParameters.getLocalClientPort(), this.m_listenBacklog, this.m_bindTo);
        ServerSocket serverServerSocket = factory.createServerSocket(this.m_serverParameters.getLocalServerPort(), this.m_listenBacklog, this.m_bindTo);
        this.m_connectionManager.connect("client-listener", clientServerSocket, (ConnectionHandlerFactory)this);
        this.m_connectionManager.connect("server-listener", serverServerSocket, (ConnectionHandlerFactory)this);
        ServerSocketFactory sslfactory = this.m_socketManager.getServerSocketFactory("secure");
        ServerSocket sslClientServerSocket = sslfactory.createServerSocket(this.m_serverParameters.getLocalSSLClientPort(), this.m_listenBacklog, this.m_bindTo);
        ServerSocket sslServerServerSocket = sslfactory.createServerSocket(this.m_serverParameters.getLocalSSLServerPort(), this.m_listenBacklog, this.m_bindTo);
        this.m_connectionManager.connect("ssl-client-listener", sslClientServerSocket, (ConnectionHandlerFactory)this);
        this.m_connectionManager.connect("ssl-server-listener", sslServerServerSocket, (ConnectionHandlerFactory)this);
        String s = "Server '" + this.m_serverParameters.getHostName() + "' initialized on" + " server2server port " + this.m_serverParameters.getLocalServerPort() + " SSL-server2server port " + this.m_serverParameters.getLocalSSLServerPort() + " client2server port " + this.m_serverParameters.getLocalClientPort() + " SSL-client2server port " + this.m_serverParameters.getLocalSSLClientPort();
        this.getLogger().info(s);
    }

    public ConnectionHandler createConnectionHandler() throws Exception {
        return (ConnectionHandler)this.m_serviceManager.lookup("IMConnectionHandler");
    }

    public void releaseConnectionHandler(ConnectionHandler connectionHandler) {
    }
}

