/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.S2SConnectorManager;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.data.Account;
import net.java.dev.openim.data.Deferrable;
import net.java.dev.openim.data.Transitable;
import net.java.dev.openim.data.jabber.User;
import net.java.dev.openim.data.storage.AccountRepositoryHolder;
import net.java.dev.openim.data.storage.DeferrableListRepositoryHolder;
import net.java.dev.openim.log.MessageLogger;
import net.java.dev.openim.log.MessageRecorder;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import net.java.dev.openim.tools.JIDParser;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class IMRouterImpl
extends AbstractLogEnabled
implements IMRouter,
Initializable,
Configurable,
Serviceable {
    private Map m_sessionMap;
    private ServerParameters m_serverParameters;
    private SessionsManager m_sessionsManager;
    private S2SConnectorManager m_s2sConnectorManager;
    private DeferrableListRepositoryHolder m_deferrableListHolder;
    private AccountRepositoryHolder m_accountHolder;
    private int m_deliveryRetryDelay;
    private int m_deliveryMaxRetry;
    private long m_deliveryMessageQueueTimeout;
    private Map m_remoteDeliveryThreadMap;
    private ServiceManager m_serviceManager;
    private MessageLogger m_messageLogger;
    private MessageRecorder m_messageRecorder;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
        this.m_deferrableListHolder = (DeferrableListRepositoryHolder)serviceManager.lookup("DeferrableListRepositoryHolder");
        this.m_accountHolder = (AccountRepositoryHolder)serviceManager.lookup("AccountRepositoryHolder");
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        this.m_messageLogger = (MessageLogger)serviceManager.lookup("MessageLogger");
        this.m_messageRecorder = (MessageRecorder)serviceManager.lookup("MessageRecorder");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_deliveryMessageQueueTimeout = configuration.getChild("delivery-message-queue-timeout").getValueAsLong(3600000L);
        this.m_deliveryMaxRetry = configuration.getChild("delivery-max-retry").getValueAsInteger(3);
        this.m_deliveryRetryDelay = configuration.getChild("delivery-retry-delay").getValueAsInteger(500);
        this.getLogger().info("Router having delivery max retry: " + this.m_deliveryMaxRetry + " and delay " + this.m_deliveryRetryDelay);
    }

    public void initialize() throws Exception {
        this.m_sessionMap = new HashMap();
        this.m_remoteDeliveryThreadMap = new HashMap();
    }

    public S2SConnectorManager getS2SConnectorManager() {
        return this.m_s2sConnectorManager;
    }

    public void setS2SConnectorManager(S2SConnectorManager s2sConnectorManager) {
        this.m_s2sConnectorManager = s2sConnectorManager;
    }

    public void registerSession(IMClientSession session) {
        User user = session.getUser();
        if (session.getConnectionType() == 1 && user != null) {
            this.getLogger().debug("Session map before register : " + this.m_sessionMap);
            this.getLogger().debug("Register session user: " + user.getNameAndRessource() + " session id " + session.getId());
            try {
                IMSession prevSession = (IMSession)this.m_sessionMap.get(user.getNameAndRessource());
                if (prevSession != null) {
                    this.getLogger().debug("Allready register session: " + prevSession.getId());
                    this.m_sessionsManager.release(prevSession);
                }
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            this.m_sessionMap.put(user.getNameAndRessource(), session);
            try {
                this.deliverQueueMessage((IMSession)session, user.getName());
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to deliver queue message " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void unregisterSession(IMClientSession session) {
        User user;
        if (session instanceof IMClientSession && (user = session.getUser()) != null) {
            this.getLogger().debug("Unregister register session user: " + user.getJIDAndRessource() + " session id " + session.getId());
            this.m_sessionMap.remove(user.getNameAndRessource());
        }
    }

    public List getAllRegisteredSession(String name) {
        ArrayList list = new ArrayList(1);
        String[] nameArray = this.m_sessionMap.keySet().toArray(new String[0]);
        int l = nameArray.length;
        for (int i = 0; i < l; ++i) {
            this.getLogger().debug("Check if " + name + " could match " + nameArray[i]);
            if (!nameArray[i].startsWith(name)) continue;
            list.add(this.m_sessionMap.get(nameArray[i]));
        }
        return list;
    }

    private IMClientSession getRegisteredSession(String name) {
        IMClientSession session = (IMClientSession)this.m_sessionMap.get(name);
        this.getLogger().debug(">>> getting session for " + name + " having map key " + this.m_sessionMap.keySet());
        if (session == null) {
            String username = name;
            if (name.indexOf(47) > 0) {
                username = JIDParser.getName(name);
            }
            List list = this.getAllRegisteredSession(name);
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                IMClientSession s = (IMClientSession)list.get(i);
                if (session != null && this.getPriorityNumber(s) <= this.getPriorityNumber(session)) continue;
                session = s;
                this.getLogger().debug("Select session " + s);
            }
        }
        return session;
    }

    private final int getPriorityNumber(IMClientSession session) {
        String priorityStr;
        int priorityNumber = 0;
        if (session.getPresence() != null && (priorityStr = session.getPresence().getPriority()) != null) {
            try {
                priorityNumber = Integer.parseInt(priorityStr);
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return priorityNumber;
    }

    public void route(IMSession currentSession, Transitable transit) throws IOException {
        String to = transit.getTo();
        String toHostname = JIDParser.getHostname(to);
        if (this.m_serverParameters.getHostNameList().contains(toHostname)) {
            IMClientSession session = this.getRegisteredSession(JIDParser.getNameAndRessource(to));
            if (session == null) {
                if (transit instanceof Deferrable) {
                    String username = JIDParser.getName(to);
                    Account account = this.m_accountHolder.getAccount(username);
                    if (account == null) {
                        this.getLogger().debug(to + " unknown user. Transit value was: " + transit);
                        String from = transit.getFrom();
                        transit.setError("Not Found");
                        transit.setErrorCode(404);
                        transit.setFrom(to);
                        transit.setTo(from);
                        transit.setType("error");
                        this.m_messageLogger.log(transit);
                        currentSession.writeOutputStream(transit.toString());
                        this.m_messageLogger.log(transit);
                        this.m_messageRecorder.record(transit);
                    } else {
                        this.getLogger().debug(to + " is not connected for getting message, should store for offline dispatch. Transit value was: " + transit);
                        ArrayList<Transitable> list = this.m_deferrableListHolder.getDeferrableList(username);
                        if (list == null) {
                            list = new ArrayList<Transitable>();
                        }
                        list.add(transit);
                        this.m_deferrableListHolder.setDeferrableList(username, list);
                    }
                }
            } else {
                transit.setTo(session.getUser().getJIDAndRessource());
                session.writeOutputStream(transit.toString());
                this.m_messageLogger.log(transit);
                this.m_messageRecorder.record(transit);
            }
        } else {
            this.getLogger().debug("Remote delivery to " + transit.getTo());
            this.enqueueRemoteDelivery(transit, currentSession);
            this.getLogger().debug("Enqueued to " + transit.getTo());
        }
    }

    public void deliverQueueMessage(IMSession currentSession, String username) throws IOException {
        List list = this.m_deferrableListHolder.getDeferrableList(username);
        if (list != null) {
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                this.route(currentSession, (Transitable)list.get(i));
            }
        }
        this.m_deferrableListHolder.setDeferrableList(username, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueRemoteDelivery(Transitable transitable, IMSession session) {
        TransitableAndSession tas = new TransitableAndSession(transitable, session);
        String hostname = tas.getHostname();
        Map map = this.m_remoteDeliveryThreadMap;
        synchronized (map) {
            RemoteDeliveryThreadPerHost remoteDeliveryThread = (RemoteDeliveryThreadPerHost)this.m_remoteDeliveryThreadMap.get(hostname);
            if (remoteDeliveryThread == null) {
                if (hostname == null) {
                    this.getLogger().warn("Absurd hostname for Transitable " + transitable);
                }
                remoteDeliveryThread = new RemoteDeliveryThreadPerHost(hostname);
                remoteDeliveryThread.enqueue(tas);
                remoteDeliveryThread.start();
                this.m_remoteDeliveryThreadMap.put(hostname, remoteDeliveryThread);
            } else {
                remoteDeliveryThread.enqueue(tas);
            }
        }
    }

    public class RemoteDeliveryThreadPerHost
    extends Thread {
        private LinkedList m_perHostRemoteDeliveryQueue;
        private IMSession m_remoteSession = null;
        private String m_hostname;
        private String m_currentStatus;

        public RemoteDeliveryThreadPerHost(String hostname) {
            this.m_hostname = hostname;
            this.m_perHostRemoteDeliveryQueue = new LinkedList();
            this.m_currentStatus = "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(TransitableAndSession tas) {
            Object object = this.m_perHostRemoteDeliveryQueue;
            synchronized (object) {
                IMRouterImpl.this.getLogger().debug("Adding tas for " + this.m_hostname + " this thread (" + this + ") isAlive: " + this.isAlive() + " current status: " + this.m_currentStatus);
                this.m_perHostRemoteDeliveryQueue.add(tas);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.m_currentStatus = "Started";
            IMRouterImpl.this.getLogger().debug("Starting thread " + this);
            while (true) {
                TransitableAndSession tas = null;
                Object object = this.m_perHostRemoteDeliveryQueue;
                synchronized (object) {
                    tas = (TransitableAndSession)this.m_perHostRemoteDeliveryQueue.removeFirst();
                    IMRouterImpl.this.getLogger().debug("Remove tas for " + this.m_hostname);
                }
                if (tas != null) {
                    this.deliver(tas);
                    IMRouterImpl.this.getLogger().debug("Delivered tas for " + this.m_hostname);
                }
                object = this;
                synchronized (object) {
                    if (this.m_perHostRemoteDeliveryQueue.isEmpty()) {
                        try {
                            IMRouterImpl.this.getLogger().debug("Thread (" + this + "/" + this.m_hostname + ") wait " + IMRouterImpl.this.m_deliveryMessageQueueTimeout);
                            this.wait(IMRouterImpl.this.m_deliveryMessageQueueTimeout);
                            IMRouterImpl.this.getLogger().debug("Thread (" + this + "/" + this.m_hostname + ") awake");
                        }
                        catch (InterruptedException e) {
                            IMRouterImpl.this.getLogger().warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                object = IMRouterImpl.this.m_remoteDeliveryThreadMap;
                synchronized (object) {
                    if (this.m_perHostRemoteDeliveryQueue.isEmpty()) {
                        IMRouterImpl.this.getLogger().debug("Removing thread (" + this + "/" + this.m_hostname + ") from list");
                        RemoteDeliveryThreadPerHost remoteDeliveryThread = (RemoteDeliveryThreadPerHost)IMRouterImpl.this.m_remoteDeliveryThreadMap.remove(this.m_hostname);
                        break;
                    }
                }
            }
            IMRouterImpl.this.m_sessionsManager.release(this.m_remoteSession);
            this.m_remoteSession = null;
            this.m_currentStatus = "Ended";
            IMRouterImpl.this.getLogger().debug("Ending thread " + this);
        }

        private void deliver(TransitableAndSession tas) {
            Transitable transitable = tas.getTransitable();
            try {
                boolean failedToDeliver = true;
                for (int retry = 0; retry < IMRouterImpl.this.m_deliveryMaxRetry; ++retry) {
                    try {
                        IMRouterImpl.this.getLogger().debug("Trying to send (" + transitable + ") to hostname " + this.m_hostname + " step " + retry);
                        if (this.m_remoteSession == null || this.m_remoteSession.isClosed()) {
                            this.m_remoteSession = IMRouterImpl.this.m_s2sConnectorManager.getRemoteSessionWaitForValidation(this.m_hostname, IMRouterImpl.this.m_deliveryMessageQueueTimeout);
                        }
                        this.m_remoteSession.writeOutputStream(transitable.toString());
                        IMRouterImpl.this.m_messageLogger.log(transitable);
                        IMRouterImpl.this.m_messageRecorder.record(transitable);
                        IMRouterImpl.this.getLogger().debug("Sent (" + transitable + ") to hostname " + this.m_hostname + " step " + retry);
                        failedToDeliver = false;
                        break;
                    }
                    catch (SocketException e) {
                        IMRouterImpl.this.m_sessionsManager.release(this.m_remoteSession);
                        this.m_remoteSession = null;
                        this.temporise(e);
                        continue;
                    }
                    catch (IOException e) {
                        IMRouterImpl.this.m_sessionsManager.release(this.m_remoteSession);
                        this.m_remoteSession = null;
                        this.temporise(e);
                        continue;
                    }
                    catch (Exception e) {
                        IMRouterImpl.this.m_sessionsManager.release(this.m_remoteSession);
                        this.m_remoteSession = null;
                        IMRouterImpl.this.getLogger().warn("Remote send failed " + e.getMessage(), (Throwable)e);
                        break;
                    }
                }
                if (failedToDeliver) {
                    String to = transitable.getTo();
                    IMRouterImpl.this.getLogger().info("Failed to sent (from " + transitable.getFrom() + ") to hostname " + this.m_hostname);
                    String from = transitable.getFrom();
                    transitable.setError("Delivery failed");
                    transitable.setErrorCode(500);
                    transitable.setFrom(to);
                    transitable.setTo(from);
                    transitable.setType("error");
                    try {
                        tas.getSession().writeOutputStream(transitable.toString());
                        IMRouterImpl.this.m_messageLogger.log(transitable);
                        IMRouterImpl.this.m_messageRecorder.record(transitable);
                    }
                    catch (IOException e) {
                        IMRouterImpl.this.getLogger().warn("Error delivery failed " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                IMRouterImpl.this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
        }

        private final void temporise(Exception e) {
            IMRouterImpl.this.getLogger().warn("Remote send failed (retying in " + IMRouterImpl.this.m_deliveryRetryDelay + "ms) " + e.getMessage());
            IMRouterImpl.this.m_sessionsManager.release(this.m_remoteSession);
            this.m_remoteSession = null;
            try {
                Thread.sleep(IMRouterImpl.this.m_deliveryRetryDelay);
            }
            catch (InterruptedException ie) {
                IMRouterImpl.this.getLogger().debug(ie.getMessage(), (Throwable)ie);
            }
        }
    }

    public class TransitableAndSession {
        private Transitable m_transitable;
        private IMSession m_session;

        public TransitableAndSession(Transitable transitable, IMSession session) {
            this.m_transitable = transitable;
            this.m_session = session;
        }

        public Transitable getTransitable() {
            return this.m_transitable;
        }

        public IMSession getSession() {
            return this.m_session;
        }

        public String getHostname() {
            return JIDParser.getHostname(this.m_transitable.getTo());
        }
    }
}

