/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import net.java.dev.openim.DefaultSessionProcessor;
import net.java.dev.openim.IMConnectionHandler;
import net.java.dev.openim.IMRouter;
import net.java.dev.openim.S2SConnectorManager;
import net.java.dev.openim.ServerParameters;
import net.java.dev.openim.session.IMClientSession;
import net.java.dev.openim.session.IMServerSession;
import net.java.dev.openim.session.IMSession;
import net.java.dev.openim.session.SessionsManager;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xmlpull.v1.XmlPullParser;

public class IMConnectionHandlerImpl
extends DefaultSessionProcessor
implements IMConnectionHandler,
ConnectionHandler,
Configurable {
    private ServerParameters m_serverParameters;
    private SessionsManager m_sessionsManager;
    private IMRouter m_router;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serverParameters = (ServerParameters)serviceManager.lookup("ServerParameters");
        this.m_sessionsManager = (SessionsManager)serviceManager.lookup("SessionsManager");
        this.m_router = (IMRouter)serviceManager.lookup("IMRouter");
        S2SConnectorManager s2sConnectorManager = (S2SConnectorManager)serviceManager.lookup("S2SConnectorManager");
        s2sConnectorManager.setConnectionHandler((IMConnectionHandler)this);
        this.m_router.setS2SConnectorManager(s2sConnectorManager);
        super.service(serviceManager);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnection(Socket socket) throws IOException, ProtocolException {
        void var2_6;
        block21: {
            void var2_5;
            this.getLogger().info("Connection from " + socket.getRemoteSocketAddress());
            IMSession iMSession = null;
            try {
                try {
                    if (socket.getLocalPort() == this.m_serverParameters.getLocalClientPort() || socket.getLocalPort() == this.m_serverParameters.getLocalSSLClientPort()) {
                        IMClientSession iMClientSession = this.m_sessionsManager.getNewClientSession();
                    } else {
                        IMServerSession iMServerSession = this.m_sessionsManager.getNewServerSession();
                    }
                    var2_5.setRouter(this.m_router);
                    this.getLogger().debug("######## [" + this.m_serverParameters.getHostName() + "] New session instance: " + var2_5.getId());
                    var2_5.setup(socket);
                    XmlPullParser xpp = var2_5.getXmlPullParser();
                    int eventType = xpp.getEventType();
                    while (eventType != 0) {
                        eventType = xpp.getEventType();
                    }
                    String s = "<?xml version='1.0' encoding='" + var2_5.getEncoding() + "' ?>";
                    var2_5.writeOutputStream(s);
                    this.process((IMSession)var2_5);
                }
                catch (SocketException e) {
                    String s = e.getMessage();
                    this.getLogger().info(s);
                    Object var7_15 = null;
                    try {
                        if (iMSession != null && this.m_sessionsManager != null) {
                            this.getLogger().info("Release session " + iMSession.getId());
                            this.m_sessionsManager.release(iMSession);
                        }
                        if (!socket.isClosed()) {
                            socket.close();
                        }
                    }
                    catch (Exception e2) {
                        this.getLogger().error(e2.getMessage(), (Throwable)e2);
                        throw new IOException(e2.getMessage());
                    }
                }
                catch (EOFException e) {
                    this.getLogger().info(e.getMessage());
                    Object var7_16 = null;
                    try {}
                    catch (Exception e2) {
                        this.getLogger().error(e2.getMessage(), (Throwable)e2);
                        throw new IOException(e2.getMessage());
                    }
                    if (iMSession != null && this.m_sessionsManager != null) {
                        this.getLogger().info("Release session " + iMSession.getId());
                        this.m_sessionsManager.release(iMSession);
                    }
                    if (!socket.isClosed()) {
                        socket.close();
                    }
                    break block21;
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                    throw new IOException(e.getMessage());
                }
                Object var7_14 = null;
            }
            catch (Throwable throwable) {
                Object var7_17 = null;
                try {}
                catch (Exception e2) {
                    this.getLogger().error(e2.getMessage(), (Throwable)e2);
                    throw new IOException(e2.getMessage());
                }
                if (iMSession != null && this.m_sessionsManager != null) {
                    this.getLogger().info("Release session " + iMSession.getId());
                    this.m_sessionsManager.release(iMSession);
                }
                if (socket.isClosed()) throw throwable;
                socket.close();
                throw throwable;
            }
            try {}
            catch (Exception e2) {
                this.getLogger().error(e2.getMessage(), (Throwable)e2);
                throw new IOException(e2.getMessage());
            }
            if (var2_5 != null && this.m_sessionsManager != null) {
                this.getLogger().info("Release session " + var2_5.getId());
                this.m_sessionsManager.release((IMSession)var2_5);
            }
            if (!socket.isClosed()) {
                socket.close();
            }
        }
        this.getLogger().info("Disconnected session " + var2_6.getId());
    }
}

