/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.openim;

import java.io.IOException;
import java.util.Properties;
import net.java.dev.openim.SessionProcessor;
import net.java.dev.openim.session.IMSession;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultSessionProcessor
extends AbstractLogEnabled
implements SessionProcessor,
Serviceable,
Configurable {
    protected Properties m_XmlEventRole;
    protected ServiceManager m_serviceManager;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] children = configuration.getChildren("map");
        this.m_XmlEventRole = new Properties();
        int l = children.length;
        for (int i = 0; i < l; ++i) {
            this.m_XmlEventRole.setProperty(children[i].getAttribute("name"), children[i].getAttribute("key"));
        }
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public void process(IMSession session) throws Exception {
        this.process(session, null);
    }

    public void process(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String currentEventName = xpp.getNamespace() + ':' + xpp.getName();
        int eventType = xpp.next();
        while (eventType != 1) {
            if (eventType == 2) {
                this.processStartTag(session, context);
            } else if (eventType == 4) {
                this.processText(session, context);
            } else if (eventType == 3 && currentEventName.equals(xpp.getNamespace() + ':' + xpp.getName())) {
                this.processEndTag(session, context);
                break;
            }
            eventType = xpp.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStartTag(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String eventName = xpp.getNamespace() + ':' + xpp.getName();
        this.getLogger().debug("[" + session.getId() + "] <" + eventName + ">");
        String roleName = this.m_XmlEventRole.getProperty(eventName);
        if (roleName != null) {
            SessionProcessor processor = null;
            try {
                processor = (SessionProcessor)this.m_serviceManager.lookup(roleName);
            }
            catch (ServiceException e) {
                this.getLogger().warn("<" + eventName + "> : " + e.getMessage(), (Throwable)e);
            }
            if (processor != null) {
                processor.process(session, context);
            } else {
                this.getLogger().warn("No processor for event: " + roleName);
                this.skip(xpp);
            }
        } else {
            this.getLogger().warn("No rolename: " + roleName + " / defined for event: " + eventName + " skipping");
            this.skip(xpp);
        }
    }

    public void processEndTag(IMSession session, Object context) throws Exception {
        XmlPullParser xpp = session.getXmlPullParser();
        String eventName = xpp.getNamespace() + ':' + xpp.getName();
        this.getLogger().debug("[" + session.getId() + "] </" + eventName + ">");
    }

    public void processText(IMSession session, Object context) throws Exception {
        String text = session.getXmlPullParser().getText().trim();
        if (text.length() > 0) {
            this.getLogger().debug("[ " + text + " ]");
        }
    }

    protected void skip(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        if (eventType == 2) {
            while (eventType != 3) {
                eventType = xpp.next();
                if (eventType != 2) continue;
                this.skip(xpp);
            }
        }
    }

    protected StringBuffer serialize(XmlPullParser xpp) throws XmlPullParserException, IOException {
        StringBuffer sb = null;
        int eventType = xpp.getEventType();
        if (eventType == 2) {
            sb = this.getStartElementAsStringBuffer(xpp);
            String elementName = xpp.getName();
            while (eventType != 3) {
                eventType = xpp.next();
                if (eventType == 2) {
                    sb.append(this.serialize(xpp));
                    continue;
                }
                if (eventType != 4) continue;
                sb.append(xpp.getText());
            }
            sb.append("</").append(elementName).append(">");
        }
        return sb;
    }

    protected String asString(XmlPullParser xpp) throws XmlPullParserException {
        String s = null;
        int eventType = xpp.getEventType();
        if (eventType == 2) {
            s = this.getStartElementAsStringBuffer(xpp).toString();
        }
        if (eventType == 4) {
            s = xpp.getText();
        }
        if (eventType == 3) {
            s = "</" + xpp.getName() + ">";
        }
        return s;
    }

    private StringBuffer getStartElementAsStringBuffer(XmlPullParser xpp) {
        StringBuffer sb = new StringBuffer();
        String elementName = xpp.getName();
        String elementNamespace = xpp.getNamespace();
        sb.append("<").append(elementName);
        if (elementNamespace != null && elementNamespace.length() > 0) {
            sb.append(" xmlns='").append(elementNamespace).append("'");
        }
        int l = xpp.getAttributeCount();
        for (int i = 0; i < l; ++i) {
            String value = xpp.getAttributeValue(i);
            String name = xpp.getAttributeName(i);
            sb.append(" ").append(name).append("='").append(value).append("'");
        }
        sb.append(">");
        return sb;
    }
}

