/**
 * Copyright (C) Posten Norge AS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package no.digipost.api.client.pdf;

import org.apache.commons.io.IOUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BlankPdf {

	private static final byte[] BLANK_ONE_PAGE_PDF;

	static {
		try {
	        BLANK_ONE_PAGE_PDF = IOUtils.toByteArray(BlankPdf.class.getResourceAsStream("blank.pdf"));
        } catch (IOException e) {
	        throw new RuntimeException(e.getMessage(), e);
        }
	}

	public static InputStream onePage() {
		return new ByteArrayInputStream(BLANK_ONE_PAGE_PDF);
	}
}
