/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import no.digipost.api.client.security.ResponseToVerify;

public final class ResponseMessageSignatureUtil {
    private static final List<String> HEADERS_FOR_SIGNATURE = Arrays.asList("Content-MD5".toLowerCase(), "Date".toLowerCase(), "X-Digipost-UserId".toLowerCase(), "X-Content-SHA256".toLowerCase());

    public static String getCanonicalResponseRepresentation(ResponseToVerify clientResponseToVerify) {
        StringBuilder s = new StringBuilder();
        s.append(ResponseMessageSignatureUtil.getCanonicalResponseCodeRepresentation(clientResponseToVerify));
        s.append(ResponseMessageSignatureUtil.getCanonicalUrlRepresentation(clientResponseToVerify));
        s.append(ResponseMessageSignatureUtil.getCanonicalHeaderRepresentation(clientResponseToVerify));
        return s.toString();
    }

    private static String getCanonicalResponseCodeRepresentation(ResponseToVerify clientResponseToVerify) {
        return clientResponseToVerify.getStatus() + "\n";
    }

    private static String getCanonicalUrlRepresentation(ResponseToVerify clientResponseToVerify) {
        return clientResponseToVerify.getPath().toLowerCase() + "\n";
    }

    private static String getCanonicalHeaderRepresentation(ResponseToVerify clientResponseToVerify) {
        SortedMap<String, String> headers = clientResponseToVerify.getHeaders();
        StringBuilder headersString = new StringBuilder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (!ResponseMessageSignatureUtil.isHeaderForSignature(key)) continue;
            headersString.append(key.toLowerCase() + ": " + entry.getValue() + "\n");
        }
        return headersString.toString();
    }

    private static boolean isHeaderForSignature(String key) {
        return HEADERS_FOR_SIGNATURE.contains(key.toLowerCase());
    }

    private ResponseMessageSignatureUtil() {
    }
}

