/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Enumeration;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoUtil.class);

    public static PrivateKey loadKeyFromP12(InputStream certificateStream, String passord) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certificateStream, passord.toCharArray());
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                RSAPrivateCrtKey key;
                String alias = aliases.nextElement();
                LOG.debug("Trying to get private key for alias: " + alias);
                if (!keyStore.isKeyEntry(alias) || (key = (RSAPrivateCrtKey)keyStore.getKey(alias, passord.toCharArray())) == null) continue;
                LOG.debug("Found private key for alias: " + alias);
                return key;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading private key", e);
        }
        throw new RuntimeException("No private key found in certificate file");
    }

    public static byte[] sign(PrivateKey privateKey, String messageToSign) {
        try {
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initSign(privateKey);
            instance.update(messageToSign.getBytes());
            return instance.sign();
        }
        catch (Exception e) {
            throw new RuntimeException("Det skjedde en feil ved signeringen", e);
        }
    }

    public static void addBouncyCastleProviderAndVerify_AES256_CBC_Support() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            LOG.debug("Registered BouncyCastleProvider");
            new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("BC").build();
            LOG.debug("Support for AES256_CBC ok");
        }
        catch (CMSException e) {
            throw new RuntimeException("Feil under initialisering av algoritmer. Er Java Cryptographic Excetsions (JCE) installert?", e);
        }
    }

    private CryptoUtil() {
    }
}

