/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.archive;

import java.net.URI;
import java.time.Clock;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import no.digipost.api.client.representations.ContentHash;
import no.digipost.api.client.representations.Link;
import no.digipost.api.client.representations.Relation;
import no.digipost.api.client.representations.Representation;
import no.digipost.api.client.representations.xml.DateTimeXmlAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="archive-document", propOrder={"uuid", "fileName", "fileType", "referenceid", "contentType", "contentHash", "archivedTime", "deletionTime", "links"})
@XmlRootElement(name="archive-document")
public class ArchiveDocument
extends Representation {
    @XmlElement(required=true)
    public final UUID uuid;
    @XmlElement(name="file-name", nillable=false)
    protected String fileName;
    @XmlElement(name="file-type", required=true)
    protected String fileType;
    @XmlElement(nillable=false)
    protected String referenceid;
    @XmlElement(name="content-type", nillable=false)
    protected String contentType;
    @XmlElement(name="content-hash", nillable=false)
    protected ContentHash contentHash;
    @XmlElement(name="archived-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime archivedTime;
    @XmlElement(name="deletion-time", type=String.class, nillable=false)
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    @XmlSchemaType(name="dateTime")
    protected ZonedDateTime deletionTime;

    public ArchiveDocument() {
        this((UUID)null, (String)null, (String)null, (String)null);
    }

    public ArchiveDocument(UUID uuid, String fileName, String fileType, String contentType) {
        super(new Link[0]);
        this.uuid = uuid;
        this.fileName = fileName;
        this.fileType = fileType;
        this.contentType = contentType;
    }

    public ArchiveDocument withReferenceId(String referenceid) {
        this.referenceid = referenceid;
        return this;
    }

    public ArchiveDocument withDeletionTime(ZonedDateTime deletionTime) {
        this.deletionTime = deletionTime;
        return this;
    }

    public ArchiveDocument withDeleteAfter(Period duration, Clock clock) {
        this.deletionTime = ZonedDateTime.now(clock).plus(duration);
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getReferenceid() {
        return this.referenceid;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ContentHash getContentHash() {
        return this.contentHash;
    }

    public void setContentHash(ContentHash value) {
        this.contentHash = value;
    }

    public ZonedDateTime getArchivedTime() {
        return this.archivedTime;
    }

    public ZonedDateTime getDeletionTime() {
        return this.deletionTime;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }

    public URI getDocumentByUUID() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_BY_UUID).getUri();
    }

    public URI getDocumentContent() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_CONTENT).getUri();
    }

    public URI getAddUniqueUUID() {
        return this.getLinkByRelationName(Relation.ADD_UNIQUE_UUID).getUri();
    }

    public URI getDocumentContentStream() {
        return this.getLinkByRelationName(Relation.GET_ARCHIVE_DOCUMENT_CONTENT_STREAM).getUri();
    }

    public URI deleteArchiveDocumentUri() {
        return this.getLinkByRelationName(Relation.DELETE_ARCHIVE_DOCUMENT_BY_UUID).getUri();
    }

    public String toString() {
        return "ArchiveDocument{uuid=" + this.uuid + ", fileName='" + this.fileName + '\'' + ", fileType='" + this.fileType + '\'' + ", referenceid='" + this.referenceid + '\'' + ", contentType='" + this.contentType + '\'' + ", contentHash=" + this.contentHash.getHashAlgorithm() + ":" + this.contentHash.getHash() + ", archivedTime=" + this.archivedTime + ", deletionTime=" + this.deletionTime + '}';
    }
}

