/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import no.digipost.api.client.representations.Representation;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="encryption-certificate", propOrder={"value"})
@XmlRootElement(name="encryption-certificate")
public class EncryptionCertificate
extends Representation {
    @XmlValue
    protected String value;

    public EncryptionCertificate() {
    }

    public EncryptionCertificate(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "EncryptionCertificate{value='" + this.value + '\'' + '}';
    }

    public X509Certificate getX509Certificate() {
        Certificate certificate;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not create X.509 certificate factory: '" + e.getMessage() + "'. Available providers: " + Stream.of(Security.getProviders()).map(Provider::getName).collect(Collectors.joining(", ")), e);
        }
        try {
            certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(this.getValue().getBytes()));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Unable to generate certificate from value " + this.getValue() + ". Message was: " + e.getMessage(), e);
        }
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new RuntimeException("Not a X.509 certificate. The given certificate of type " + certificate.getType() + " can not be used.");
    }
}

