/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.http.response.interceptor;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.protocol.HttpContext;

public class ResponseDateInterceptor
implements HttpResponseInterceptor {
    private static final Duration ACCEPTABLE_TIME_DIFF = Duration.ofMinutes(5L);
    private final Clock clock;

    public ResponseDateInterceptor(Clock clock) {
        this.clock = clock;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        String dateHeader = Optional.ofNullable(response.getFirstHeader("Date")).map(NameValuePair::getValue).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElseThrow(() -> new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, String.format("Missing %s header in response. This header is expected in all response. Http status was %s", "Date", response.getStatusLine())));
        this.checkDate(dateHeader);
    }

    private void checkDate(String dateOnRFC1123Format) {
        try {
            ZonedDateTime date = DateUtils.parseDate(dateOnRFC1123Format);
            this.sjekkAtDatoHeaderIkkeErForGammel(dateOnRFC1123Format, date);
            this.sjekkAtDatoHeaderIkkeErForNy(dateOnRFC1123Format, date);
        }
        catch (DateTimeParseException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Unable to parse Date header '" + dateOnRFC1123Format + "' (is it 'RFC 1123 compliant'?)");
        }
    }

    private void sjekkAtDatoHeaderIkkeErForGammel(String headerDate, ZonedDateTime parsedDate) {
        if (parsedDate.isBefore(ZonedDateTime.now(this.clock).minus(ACCEPTABLE_TIME_DIFF))) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Date header in response from server is too old: " + headerDate);
        }
    }

    private void sjekkAtDatoHeaderIkkeErForNy(String headerDate, ZonedDateTime parsedDate) {
        if (parsedDate.isAfter(ZonedDateTime.now(this.clock).plus(ACCEPTABLE_TIME_DIFF))) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Date-header from server is too early: " + headerDate);
        }
    }
}

