/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.delivery;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import no.digipost.api.client.delivery.OngoingDelivery;
import no.digipost.api.client.internal.delivery.DocumentContent;
import no.digipost.api.client.internal.delivery.MessageDeliverer;
import no.digipost.api.client.representations.Document;
import no.digipost.api.client.representations.Message;
import no.digipost.api.client.representations.MessageDelivery;

final class PrintOnlyMessage
implements OngoingDelivery.SendableForPrintOnly {
    private final MessageDeliverer sender;
    private final Message printMessage;
    private final Map<UUID, DocumentContent> documents = new LinkedHashMap<UUID, DocumentContent>();

    PrintOnlyMessage(Message printMessage, MessageDeliverer sender) {
        if (!printMessage.isDirectPrint()) {
            throw new IllegalArgumentException("Direct print messages must have PrintDetails and cannot have DigipostAddress, PersonalIdentificationNumber or NameAndAddress");
        }
        this.printMessage = printMessage;
        this.sender = sender;
    }

    @Override
    public PrintOnlyMessage addContent(Document document, InputStream content) {
        this.documents.put(document.uuid, DocumentContent.CreatePrintContent(content));
        return this;
    }

    @Override
    public MessageDelivery send() {
        return this.sender.sendMultipartMessage(this.printMessage, this.documents);
    }
}

