/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.internal.delivery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.digipost.api.client.DigipostClientConfig;
import no.digipost.api.client.EventLogger;
import no.digipost.api.client.archive.ArchiveApi;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.internal.delivery.DocumentContent;
import no.digipost.api.client.internal.delivery.PerformingArchivingDocuments;
import no.digipost.api.client.internal.http.response.HttpResponseUtils;
import no.digipost.api.client.representations.archive.Archive;
import no.digipost.api.client.representations.archive.ArchiveDocument;
import no.digipost.api.client.util.JAXBContextUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveDeliverer {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveDeliverer.class);
    private final ArchiveApi apiService;
    private final EventLogger eventLogger;

    public ArchiveDeliverer(DigipostClientConfig config, ArchiveApi apiService) {
        this.eventLogger = config.eventLogger.withDebugLogTo(LOG);
        this.apiService = apiService;
    }

    public ArchiveApi.ArchivingDocuments createArchive(Archive archive) {
        return new PerformingArchivingDocuments(archive, this);
    }

    public Archive sendMultipartMessage(Archive archive, Map<UUID, DocumentContent> documentsAndContent) {
        Archive archive2;
        block12: {
            Map documentInputStream = archive.getDocuments().stream().collect(Collectors.toMap(Function.identity(), doc -> ((DocumentContent)documentsAndContent.get(doc.getUuid())).getDigipostContent()));
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            JAXBContextUtils.marshal(JAXBContextUtils.jaxbContext, archive, (OutputStream)bao);
            ByteArrayBody attachment = new ByteArrayBody(bao.toByteArray(), ContentType.create((String)"application/vnd.digipost-v7+xml", (Charset)StandardCharsets.UTF_8), "archive");
            MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.STRICT).setMimeSubtype("vnd.digipost-v7+xml").addPart(FormBodyPartBuilder.create((String)"archive", (ContentBody)attachment).addField("Content-Disposition", "attachment; filename=\"archive\"").build());
            for (Map.Entry documentAndContent : documentInputStream.entrySet()) {
                ArchiveDocument document = (ArchiveDocument)documentAndContent.getKey();
                InputStream content = documentAndContent.getValue();
                byte[] bytes = IOUtils.toByteArray((InputStream)content);
                multipartEntity = multipartEntity.addPart(FormBodyPartBuilder.create((String)"application", (ContentBody)new ByteArrayBody(bytes, ContentType.create((String)((String)StringUtils.defaultIfBlank((CharSequence)document.getContentType(), (CharSequence)"application/octet-stream"))), document.uuid.toString())).addField("Content-Disposition", "attachment; filename=\"" + document.uuid.toString() + "\"").build());
            }
            this.eventLogger.log("*** STARTER INTERAKSJON MED API: Arkiverer filer ***");
            CloseableHttpResponse response = this.apiService.sendMultipartArchive(multipartEntity.build());
            try {
                HttpResponseUtils.checkResponse((HttpResponse)response, this.eventLogger);
                this.eventLogger.log("Arkivdokumentet ble sendt. Status: [" + response + "]");
                archive2 = JAXBContextUtils.unmarshal(JAXBContextUtils.jaxbContext, response.getEntity().getContent(), Archive.class);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DigipostClientException(ErrorCode.GENERAL_ERROR, e.getMessage());
                    }
                }
                catch (Exception e) {
                    throw DigipostClientException.from(e);
                }
            }
            response.close();
        }
        return archive2;
    }
}

