/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import no.arktekk.siren.Classes;
import no.arktekk.siren.Entity;
import no.arktekk.siren.JsonSerializable;
import no.arktekk.siren.JsonSerializer;
import no.arktekk.siren.MIMEType;
import no.arktekk.siren.Rel;

public abstract class SubEntity
implements JsonSerializable {
    private SubEntity() {
    }

    public <X> X fold(Function<EmbeddedRepresentation, X> representation, Function<EmbeddedLink, X> link) {
        if (this instanceof EmbeddedRepresentation) {
            return representation.apply((EmbeddedRepresentation)this);
        }
        if (this instanceof EmbeddedLink) {
            return link.apply((EmbeddedLink)this);
        }
        throw new RuntimeException("Unsupported SubEntity type");
    }

    @Override
    public <T> T toJson(JsonSerializer<T> serializer) {
        return (T)this.fold(serializer::serialize, serializer::serialize);
    }

    public static final class EmbeddedLink
    extends SubEntity {
        public final Rel rel;
        public final URI href;
        public final Optional<Classes> classes;
        public final Optional<MIMEType> type;
        public final Optional<String> title;

        public EmbeddedLink(Rel rel, URI href, Optional<Classes> classes, Optional<MIMEType> type, Optional<String> title) {
            this.rel = rel;
            this.href = href;
            this.classes = classes;
            this.type = type;
            this.title = title;
        }

        public static EmbeddedLink of(Rel rel, URI href) {
            return new EmbeddedLink(rel, href, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public EmbeddedLink with(Classes classes) {
            return new EmbeddedLink(this.rel, this.href, Optional.of(classes), this.type, this.title);
        }

        public EmbeddedLink with(MIMEType type) {
            return new EmbeddedLink(this.rel, this.href, this.classes, Optional.of(type), this.title);
        }

        public EmbeddedLink with(String title) {
            return new EmbeddedLink(this.rel, this.href, this.classes, this.type, Optional.of(title));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmbeddedLink that = (EmbeddedLink)o;
            if (!this.classes.equals(that.classes)) {
                return false;
            }
            if (!this.rel.equals(that.rel)) {
                return false;
            }
            if (!this.href.equals(that.href)) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
            return this.title.equals(that.title);
        }

        public int hashCode() {
            int result = this.classes.hashCode();
            result = 31 * result + this.rel.hashCode();
            result = 31 * result + this.href.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.title.hashCode();
            return result;
        }
    }

    public static final class EmbeddedRepresentation
    extends SubEntity {
        public final Rel rel;
        public final Entity entity;

        public EmbeddedRepresentation(Rel rel, Entity entity) {
            this.rel = rel;
            this.entity = entity;
        }

        public static EmbeddedRepresentation of(Rel rel, Entity entity) {
            return new EmbeddedRepresentation(rel, entity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmbeddedRepresentation that = (EmbeddedRepresentation)o;
            if (!this.rel.equals(that.rel)) {
                return false;
            }
            return this.entity.equals(that.entity);
        }

        public int hashCode() {
            int result = this.rel.hashCode();
            result = 31 * result + this.entity.hashCode();
            return result;
        }
    }
}

