/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import no.arktekk.siren.util.StreamUtils;

public final class MIMEType {
    public static final MIMEType All = new MIMEType("*", "*");
    public static final MIMEType JSON = MIMEType.application("json");
    public static final MIMEType SIREN = MIMEType.application("vnd.siren+json");
    public static final MIMEType URLEncoded = MIMEType.application("x-www-form-urlencoded");
    private static final Pattern MIMETypePattern = Pattern.compile("(\\w+|\\*)/([\\w\\.\\-\\+]+|\\*);?(.*)?");
    private final String major;
    private final String minor;
    private final SortedMap<String, String> parameters;

    public static Optional<MIMEType> parse(String s) {
        Matcher matcher = MIMETypePattern.matcher(s);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            TreeMap<String, String> params = new TreeMap<String, String>(Comparator.naturalOrder());
            if (matcher.groupCount() == 4) {
                String[] parts;
                String group = matcher.group(3);
                for (String part : parts = group.split(";")) {
                    String[] split = part.split("=");
                    if (split.length == 2) {
                        params.put(split[0].trim(), split[1].trim());
                        continue;
                    }
                    params.put(split[0].trim(), "");
                }
            }
            return Optional.of(new MIMEType(major, minor, params));
        }
        return Optional.empty();
    }

    public static MIMEType application(String minor) {
        return new MIMEType("application", minor);
    }

    public static MIMEType application(String minor, Map<String, String> map) {
        return new MIMEType("application", minor, MIMEType.parameterMap(map));
    }

    public static MIMEType text(String minor) {
        return new MIMEType("text", minor);
    }

    public static MIMEType text(String minor, Map<String, String> map) {
        return new MIMEType("text", minor, MIMEType.parameterMap(map));
    }

    public static SortedMap<String, String> parameterMap(Map<String, String> m) {
        if (m instanceof SortedMap) {
            return (SortedMap)m;
        }
        TreeMap<String, String> tm = new TreeMap<String, String>(Comparator.naturalOrder());
        tm.putAll(m);
        return tm;
    }

    public MIMEType(String major, String minor) {
        this(major.toLowerCase(), minor.toLowerCase(), new TreeMap<String, String>(Comparator.naturalOrder()));
    }

    public MIMEType(String major, String minor, SortedMap<String, String> parameters) {
        this.major = Objects.requireNonNull(major, "major was null");
        this.minor = Objects.requireNonNull(minor, "minor was null");
        this.parameters = Collections.unmodifiableSortedMap(Objects.requireNonNull(parameters, "Parameters was null"));
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public SortedMap<String, String> getParameters() {
        return this.parameters;
    }

    public String format() {
        String formatted = String.format("%s/%s", this.major, this.minor);
        if (!this.parameters.isEmpty()) {
            String params = this.parameters.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining("; ", "; ", ""));
            return formatted + params;
        }
        return formatted;
    }

    public boolean includes(MIMEType mt) {
        boolean includes;
        boolean bl = includes = All.equals(this, false) || this.equals(mt, false);
        if (!includes) {
            includes = mt != null && this.major.equals(mt.major) && (this.minor.equals("*") || this.minor.equals(mt.minor));
        }
        return includes;
    }

    public boolean includedBy(MIMEType mt) {
        boolean includes;
        boolean bl = includes = null == mt || All.equals(mt, false) || this.equals(mt, false);
        if (!includes) {
            includes = this.major.equals(mt.major) && (mt.minor.equals("*") || this.minor.equals(mt.minor));
        }
        return includes;
    }

    public boolean equals(MIMEType mt, boolean includeParams) {
        boolean equals;
        if (this == mt) {
            return true;
        }
        if (mt == null) {
            return false;
        }
        boolean bl = equals = this.getMajor().equals(mt.getMajor()) && this.getMinor().equals(mt.getMinor());
        if (includeParams) {
            equals = equals && StreamUtils.zip(this.getParameters().entrySet().stream(), mt.getParameters().entrySet().stream(), (a, b) -> new AbstractMap.SimpleImmutableEntry<Map.Entry, Map.Entry>((Map.Entry)a, (Map.Entry)b)).allMatch(e -> ((Map.Entry)e.getKey()).equals(e.getValue()));
        }
        return equals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIMEType mimeType = (MIMEType)o;
        return this.equals(mimeType, true);
    }

    public int hashCode() {
        int result = this.major.hashCode();
        result = 31 * result + this.minor.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return "MIMEType{major='" + this.major + '\'' + ", minor='" + this.minor + '\'' + ", parameters=" + this.parameters + '}';
    }
}

