/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import no.arktekk.siren.Entity;
import no.arktekk.siren.SubEntity;
import no.arktekk.siren.util.StreamUtils;
import org.glassfish.json.JsonFactory;

public interface JsonSerializer<T> {
    public T serialize(SubEntity.EmbeddedRepresentation var1);

    public T serialize(SubEntity.EmbeddedLink var1);

    public T serialize(Entity var1);

    public static final class JavaxJsonSerializer
    implements JsonSerializer<JsonValue> {
        private static Function<Iterable<String>, JsonArray> FromIterableString = strings -> JsonFactory.arrayOf(StreamUtils.stream(strings).map(JsonFactory::jsonString).collect(Collectors.toList()));

        private JsonObjectBuilder sirenBuilder(Entity entity) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            entity.classes.ifPresent(cs -> builder.add("class", (JsonValue)FromIterableString.apply((Iterable<String>)cs)));
            entity.properties.ifPresent(ps -> builder.add("properties", (JsonValue)ps));
            entity.entities.ifPresent(es -> builder.add("entities", (JsonValue)JsonFactory.arrayOf(es.stream().map(e -> e.toJson(this)).collect(Collectors.toList()))));
            entity.links.ifPresent(ls -> builder.add("links", (JsonValue)JsonFactory.arrayOf(ls.stream().map(l -> {
                JsonObjectBuilder link = Json.createObjectBuilder();
                link.add("rel", (JsonValue)FromIterableString.apply(l.rel));
                link.add("href", l.href.toString());
                return link.build();
            }).collect(Collectors.toList()))));
            entity.actions.ifPresent(as -> builder.add("actions", (JsonValue)JsonFactory.arrayOf(as.stream().map(a -> {
                JsonObjectBuilder action = Json.createObjectBuilder();
                action.add("name", a.name);
                a.classes.ifPresent(cs -> action.add("class", (JsonValue)FromIterableString.apply((Iterable<String>)cs)));
                a.method.ifPresent(m -> action.add("method", m.name()));
                action.add("href", a.href.toString());
                a.title.ifPresent(t -> action.add("title", t));
                a.type.ifPresent(t -> action.add("type", t.format()));
                a.fields.ifPresent(fs -> action.add("fields", (JsonValue)JsonFactory.arrayOf(fs.stream().map(f -> {
                    JsonObjectBuilder field = Json.createObjectBuilder();
                    field.add("name", f.name);
                    f.classes.ifPresent(cs -> field.add("class", (JsonValue)FromIterableString.apply((Iterable<String>)cs)));
                    field.add("type", f.type.value);
                    f.value.ifPresent(v -> field.add("value", v));
                    f.title.ifPresent(t -> field.add("title", t));
                    return field.build();
                }).collect(Collectors.toList()))));
                return action.build();
            }).collect(Collectors.toList()))));
            entity.title.ifPresent(t -> builder.add("title", t));
            return builder;
        }

        @Override
        public JsonValue serialize(Entity entity) {
            return this.sirenBuilder(entity).build();
        }

        @Override
        public JsonValue serialize(SubEntity.EmbeddedRepresentation embeddedRepresentation) {
            return this.sirenBuilder(embeddedRepresentation.entity).add("rel", (JsonValue)FromIterableString.apply(embeddedRepresentation.rel)).build();
        }

        @Override
        public JsonValue serialize(SubEntity.EmbeddedLink embeddedLink) {
            JsonObjectBuilder object = Json.createObjectBuilder();
            embeddedLink.classes.ifPresent(cs -> object.add("class", (JsonValue)FromIterableString.apply((Iterable<String>)cs)));
            object.add("rel", (JsonValue)FromIterableString.apply(embeddedLink.rel));
            object.add("href", embeddedLink.href.toString());
            embeddedLink.title.ifPresent(t -> object.add("title", t));
            embeddedLink.type.ifPresent(t -> object.add("type", t.format()));
            return object.build();
        }
    }
}

