/*
 * Decompiled with CFR 0.152.
 */
package no.arktekk.siren;

import java.util.Optional;
import javax.json.JsonValue;
import no.arktekk.siren.Classes;

public final class Field {
    public final String name;
    public final Type type;
    public final Optional<Classes> classes;
    public final Optional<JsonValue> value;
    public final Optional<String> title;

    public Field(String name, Type type, Optional<Classes> classes, Optional<JsonValue> value, Optional<String> title) {
        this.name = name;
        this.type = type;
        this.classes = classes;
        this.value = value;
        this.title = title;
    }

    public static Field of(String name) {
        return new Field(name, Type.TEXT, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Field of(String name, Type type) {
        return new Field(name, type, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Field with(Classes classes) {
        return new Field(this.name, this.type, Optional.of(classes), this.value, this.title);
    }

    public Field with(JsonValue value) {
        return new Field(this.name, this.type, this.classes, Optional.of(value), this.title);
    }

    public Field with(String title) {
        return new Field(this.name, this.type, this.classes, this.value, Optional.of(title));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (!this.name.equals(field.name)) {
            return false;
        }
        if (!this.classes.equals(field.classes)) {
            return false;
        }
        if (this.type != field.type) {
            return false;
        }
        if (!this.value.equals(field.value)) {
            return false;
        }
        return this.title.equals(field.title);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.classes.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.title.hashCode();
        return result;
    }

    public static enum Type {
        HIDDEN("hidden"),
        TEXT("text"),
        SEARCH("search"),
        TEL("tel"),
        URL("url"),
        EMAIL("email"),
        PASSWORD("password"),
        DATETIME("datetime"),
        DATE("date"),
        MONTH("month"),
        WEEK("week"),
        TIME("time"),
        DATETIME_LOCAL("datetime-local"),
        NUMBER("number"),
        RANGE("range"),
        COLOR("color"),
        CHECKBOX("checkbox"),
        RADIO("radio"),
        FILE("file");

        public String value;

        private Type(String s) {
            this.value = s;
        }

        public static Type fromString(String s) {
            for (Type v : Type.values()) {
                if (!v.value.equals(s)) continue;
                return v;
            }
            return TEXT;
        }
    }
}

